/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.common.jdom;

import java.util.Collection;
import java.util.Iterator;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.commonjava.maven.ext.common.jdom.IndentationCounter;
import org.commonjava.maven.ext.common.jdom.Utils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMFactory;
import org.jdom2.UncheckedJDOMFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDOMModelConverter {
    protected final JDOMFactory factory = new UncheckedJDOMFactory();
    protected final Logger logger = LoggerFactory.getLogger(JDOMModelConverter.class);

    public void convertModelToJDOM(Model model, Document document) {
        this.update(model, new IndentationCounter(0), document.getRootElement());
    }

    protected void iterateContributor(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = parent.getChild("contributors", parent.getNamespace());
        if (element == null) {
            element = Utils.updateElement(counter, parent, "contributors", shouldExist);
        }
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("contributor", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Contributor value = (Contributor)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("contributor", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateContributor(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        } else {
            this.removeExisting(element, "contributor");
        }
    }

    protected void iterateDependency(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = parent.getChild("dependencies", parent.getNamespace());
        if (element == null) {
            element = Utils.updateElement(counter, parent, "dependencies", shouldExist);
        }
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("dependency", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Dependency value = (Dependency)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("dependency", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateDependency(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        } else {
            this.removeExisting(element, "dependency");
        }
    }

    protected void iterateDeveloper(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = parent.getChild("developers", parent.getNamespace());
        if (element == null) {
            element = Utils.updateElement(counter, parent, "developers", shouldExist);
        }
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("developer", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Developer value = (Developer)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("developer", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateDeveloper(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        } else {
            this.removeExisting(element, "developer");
        }
    }

    protected void iterateExclusion(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = Utils.updateElement(counter, parent, "exclusions", shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("exclusion", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Exclusion value = (Exclusion)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("exclusion", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateExclusion(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        } else {
            this.removeExisting(element, "exclusion");
        }
    }

    protected void iterateExtension(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = Utils.updateElement(counter, parent, "extensions", shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("extension", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Extension value = (Extension)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("extension", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateExtension(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateLicense(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = parent.getChild("licenses", parent.getNamespace());
        if (element == null) {
            element = Utils.updateElement(counter, parent, "licenses", shouldExist);
        }
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("license", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                License value = (License)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("license", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateLicense(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        } else {
            this.removeExisting(element, "license");
        }
    }

    protected void iterateMailingList(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = parent.getChild("mailingLists", parent.getNamespace());
        if (element == null) {
            element = Utils.updateElement(counter, parent, "mailingLists", shouldExist);
        }
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("mailingList", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                MailingList value = (MailingList)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("mailingList", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateMailingList(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        } else {
            this.removeExisting(element, "mailingList");
        }
    }

    protected void iterateNotifier(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = Utils.updateElement(counter, parent, "notifiers", shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("notifier", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Notifier value = (Notifier)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("notifier", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateNotifier(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        } else {
            this.removeExisting(element, "notifier");
        }
    }

    protected void iteratePlugin(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = Utils.updateElement(counter, parent, "plugins", shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("plugin", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Plugin value = (Plugin)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("plugin", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updatePlugin(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        } else {
            this.removeExisting(element, "plugin");
        }
    }

    protected void iteratePluginExecution(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = Utils.updateElement(counter, parent, "executions", shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("execution", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                PluginExecution value = (PluginExecution)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("execution", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updatePluginExecution(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        } else {
            this.removeExisting(element, "execution");
        }
    }

    protected void iterateProfile(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = parent.getChild("profiles", parent.getNamespace());
        if (element == null) {
            element = Utils.updateElement(counter, parent, "profiles", shouldExist);
        }
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("profile", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Profile value = (Profile)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("profile", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateProfile(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        } else {
            this.removeExisting(element, "profile");
        }
    }

    protected void iterateReportPlugin(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = Utils.updateElement(counter, parent, "plugins", shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("plugin", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                ReportPlugin value = (ReportPlugin)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("plugin", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateReportPlugin(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        } else {
            this.removeExisting(element, "plugin");
        }
    }

    protected void iterateReportSet(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = Utils.updateElement(counter, parent, "reportSets", shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("reportSet", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                ReportSet value = (ReportSet)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("reportSet", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateReportSet(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        } else {
            this.removeExisting(element, "reportSet");
        }
    }

    protected void iterateRepository(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = parent.getChild(parentTag, parent.getNamespace());
        if (element == null) {
            element = Utils.updateElement(counter, parent, parentTag, shouldExist);
        }
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Repository value = (Repository)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateRepository(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        } else {
            this.removeExisting(element, childTag);
        }
    }

    protected void iterateResource(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = Utils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Resource value = (Resource)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateResource(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        } else {
            this.removeExisting(element, childTag);
        }
    }

    protected void updateActivation(Activation activation, IndentationCounter counter, Element element) {
        boolean shouldExist = activation != null;
        Element root = Utils.updateElement(counter, element, "activation", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "activeByDefault", !activation.isActiveByDefault() ? null : String.valueOf(activation.isActiveByDefault()), "false");
            Utils.findAndReplaceSimpleElement(innerCount, root, "jdk", activation.getJdk(), null);
            this.updateActivationOS(activation.getOs(), innerCount, root);
            this.updateActivationProperty(activation.getProperty(), innerCount, root);
            this.updateActivationFile(activation.getFile(), innerCount, root);
        }
    }

    protected void updateActivationFile(ActivationFile activationFile, IndentationCounter counter, Element element) {
        boolean shouldExist = activationFile != null;
        Element root = Utils.updateElement(counter, element, "file", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "missing", activationFile.getMissing(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "exists", activationFile.getExists(), null);
        }
    }

    protected void updateActivationOS(ActivationOS activationOS, IndentationCounter counter, Element element) {
        boolean shouldExist = activationOS != null;
        Element root = Utils.updateElement(counter, element, "os", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "name", activationOS.getName(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "family", activationOS.getFamily(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "arch", activationOS.getArch(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "version", activationOS.getVersion(), null);
        }
    }

    protected void updateActivationProperty(ActivationProperty activationProperty, IndentationCounter counter, Element element) {
        boolean shouldExist = activationProperty != null;
        Element root = Utils.updateElement(counter, element, "property", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "name", activationProperty.getName(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "value", activationProperty.getValue(), null);
        }
    }

    protected void updateBuild(Build build, IndentationCounter counter, Element element) {
        boolean shouldExist = build != null;
        Element root = Utils.updateElement(counter, element, "build", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "sourceDirectory", build.getSourceDirectory(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "scriptSourceDirectory", build.getScriptSourceDirectory(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "testSourceDirectory", build.getTestSourceDirectory(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "outputDirectory", build.getOutputDirectory(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "testOutputDirectory", build.getTestOutputDirectory(), null);
            this.iterateExtension(innerCount, root, build.getExtensions());
            Utils.findAndReplaceSimpleElement(innerCount, root, "defaultGoal", build.getDefaultGoal(), null);
            this.iterateResource(innerCount, root, build.getResources(), "resources", "resource");
            this.iterateResource(innerCount, root, build.getTestResources(), "testResources", "testResource");
            Utils.findAndReplaceSimpleElement(innerCount, root, "directory", build.getDirectory(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "finalName", build.getFinalName(), null);
            Utils.findAndReplaceSimpleLists(innerCount, root, build.getFilters(), "filters", "filter");
            this.updatePluginManagement(build.getPluginManagement(), innerCount, root);
            this.iteratePlugin(innerCount, root, build.getPlugins());
        }
    }

    protected void updateBuildBase(BuildBase buildBase, IndentationCounter counter, Element element) {
        boolean shouldExist = buildBase != null;
        Element root = Utils.updateElement(counter, element, "build", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "defaultGoal", buildBase.getDefaultGoal(), null);
            this.iterateResource(innerCount, root, buildBase.getResources(), "resources", "resource");
            this.iterateResource(innerCount, root, buildBase.getTestResources(), "testResources", "testResource");
            Utils.findAndReplaceSimpleElement(innerCount, root, "directory", buildBase.getDirectory(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "finalName", buildBase.getFinalName(), null);
            Utils.findAndReplaceSimpleLists(innerCount, root, buildBase.getFilters(), "filters", "filter");
            this.updatePluginManagement(buildBase.getPluginManagement(), innerCount, root);
            this.iteratePlugin(innerCount, root, buildBase.getPlugins());
        }
    }

    protected void updateCiManagement(CiManagement ciManagement, IndentationCounter counter, Element element) {
        boolean shouldExist = ciManagement != null;
        Element root = Utils.updateElement(counter, element, "ciManagement", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "system", ciManagement.getSystem(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "url", ciManagement.getUrl(), null);
            this.iterateNotifier(innerCount, root, ciManagement.getNotifiers());
        }
    }

    protected void updateContributor(Contributor contributor, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "name", contributor.getName(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "email", contributor.getEmail(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "url", contributor.getUrl(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "organization", contributor.getOrganization(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "organizationUrl", contributor.getOrganizationUrl(), null);
        Utils.findAndReplaceSimpleLists(innerCount, element, contributor.getRoles(), "roles", "role");
        Utils.findAndReplaceSimpleElement(innerCount, element, "timezone", contributor.getTimezone(), null);
        Utils.findAndReplaceProperties(innerCount, element, "properties", contributor.getProperties());
    }

    protected void updateDependency(Dependency dependency, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "groupId", dependency.getGroupId(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "artifactId", dependency.getArtifactId(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "version", dependency.getVersion(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "type", dependency.getType(), "jar");
        Utils.findAndReplaceSimpleElement(innerCount, element, "classifier", dependency.getClassifier(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "scope", dependency.getScope(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "systemPath", dependency.getSystemPath(), null);
        this.iterateExclusion(innerCount, element, dependency.getExclusions());
        Utils.findAndReplaceSimpleElement(innerCount, element, "optional", dependency.getOptional(), null);
    }

    protected void updateDependencyManagement(DependencyManagement dependencyManagement, IndentationCounter counter, Element element) {
        boolean shouldExist = dependencyManagement != null;
        Element root = Utils.updateElement(counter, element, "dependencyManagement", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            this.iterateDependency(innerCount, root, dependencyManagement.getDependencies());
        }
    }

    protected void updateDeploymentRepository(DeploymentRepository deploymentRepository, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = deploymentRepository != null;
        Element root = Utils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "uniqueVersion", String.valueOf(deploymentRepository.isUniqueVersion()), "true");
            this.updateRepositoryPolicy(deploymentRepository.getReleases(), "releases", innerCount, root);
            this.updateRepositoryPolicy(deploymentRepository.getSnapshots(), "snapshots", innerCount, root);
            Utils.findAndReplaceSimpleElement(innerCount, root, "id", deploymentRepository.getId(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "name", deploymentRepository.getName(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "url", deploymentRepository.getUrl(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "layout", deploymentRepository.getLayout(), "default");
        }
    }

    protected void updateDeveloper(Developer developer, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "id", developer.getId(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "name", developer.getName(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "email", developer.getEmail(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "url", developer.getUrl(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "organization", developer.getOrganization(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "organizationUrl", developer.getOrganizationUrl(), null);
        Utils.findAndReplaceSimpleLists(innerCount, element, developer.getRoles(), "roles", "role");
        Utils.findAndReplaceSimpleElement(innerCount, element, "timezone", developer.getTimezone(), null);
        Utils.findAndReplaceProperties(innerCount, element, "properties", developer.getProperties());
    }

    protected void updateDistributionManagement(DistributionManagement distributionManagement, IndentationCounter counter, Element element) {
        boolean shouldExist = distributionManagement != null;
        Element root = Utils.updateElement(counter, element, "distributionManagement", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            this.updateDeploymentRepository(distributionManagement.getRepository(), "repository", innerCount, root);
            this.updateDeploymentRepository(distributionManagement.getSnapshotRepository(), "snapshotRepository", innerCount, root);
            this.updateSite(distributionManagement.getSite(), innerCount, root);
            Utils.findAndReplaceSimpleElement(innerCount, root, "downloadUrl", distributionManagement.getDownloadUrl(), null);
            this.updateRelocation(distributionManagement.getRelocation(), innerCount, root);
            Utils.findAndReplaceSimpleElement(innerCount, root, "status", distributionManagement.getStatus(), null);
        }
    }

    protected void updateExclusion(Exclusion exclusion, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "artifactId", exclusion.getArtifactId(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "groupId", exclusion.getGroupId(), null);
    }

    protected void updateExtension(Extension extension, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "groupId", extension.getGroupId(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "artifactId", extension.getArtifactId(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "version", extension.getVersion(), null);
    }

    protected void updateIssueManagement(IssueManagement issueManagement, IndentationCounter counter, Element element) {
        boolean shouldExist = issueManagement != null;
        Element root = Utils.updateElement(counter, element, "issueManagement", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "system", issueManagement.getSystem(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "url", issueManagement.getUrl(), null);
        }
    }

    protected void updateLicense(License license, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "name", license.getName(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "url", license.getUrl(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "distribution", license.getDistribution(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "comments", license.getComments(), null);
    }

    protected void updateMailingList(MailingList mailingList, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "name", mailingList.getName(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "subscribe", mailingList.getSubscribe(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "unsubscribe", mailingList.getUnsubscribe(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "post", mailingList.getPost(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "archive", mailingList.getArchive(), null);
        Utils.findAndReplaceSimpleLists(innerCount, element, mailingList.getOtherArchives(), "otherArchives", "otherArchive");
    }

    protected void updateModel(Model model, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "modelVersion", model.getModelVersion(), null);
        this.updateParent(model.getParent(), innerCount, element);
        Utils.findAndReplaceSimpleElement(innerCount, element, "groupId", model.getGroupId(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "artifactId", model.getArtifactId(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "version", model.getVersion(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "packaging", model.getPackaging(), "jar");
        Utils.findAndReplaceSimpleElement(innerCount, element, "name", model.getName(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "description", model.getDescription(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "url", model.getUrl(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "inceptionYear", model.getInceptionYear(), null);
        this.updateOrganization(model.getOrganization(), innerCount, element);
        this.iterateLicense(innerCount, element, model.getLicenses());
        this.iterateDeveloper(innerCount, element, model.getDevelopers());
        this.iterateContributor(innerCount, element, model.getContributors());
        this.iterateMailingList(innerCount, element, model.getMailingLists());
        this.updatePrerequisites(model.getPrerequisites(), innerCount, element);
        Utils.findAndReplaceSimpleLists(innerCount, element, model.getModules(), "modules", "module");
        this.updateScm(model.getScm(), innerCount, element);
        this.updateIssueManagement(model.getIssueManagement(), innerCount, element);
        this.updateCiManagement(model.getCiManagement(), innerCount, element);
        this.updateDistributionManagement(model.getDistributionManagement(), innerCount, element);
        Utils.findAndReplaceProperties(innerCount, element, "properties", model.getProperties());
        this.updateDependencyManagement(model.getDependencyManagement(), innerCount, element);
        this.iterateDependency(innerCount, element, model.getDependencies());
        this.iterateRepository(innerCount, element, model.getRepositories(), "repositories", "repository");
        this.iterateRepository(innerCount, element, model.getPluginRepositories(), "pluginRepositories", "pluginRepository");
        this.updateBuild(model.getBuild(), innerCount, element);
        Utils.findAndReplaceXpp3DOM(innerCount, element, "reports", (Xpp3Dom)model.getReports());
        this.updateReporting(model.getReporting(), innerCount, element);
        this.iterateProfile(innerCount, element, model.getProfiles());
    }

    protected void updateNotifier(Notifier notifier, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "type", notifier.getType(), "mail");
        Utils.findAndReplaceSimpleElement(innerCount, element, "sendOnError", String.valueOf(notifier.isSendOnError()), "true");
        Utils.findAndReplaceSimpleElement(innerCount, element, "sendOnFailure", String.valueOf(notifier.isSendOnFailure()), "true");
        Utils.findAndReplaceSimpleElement(innerCount, element, "sendOnSuccess", String.valueOf(notifier.isSendOnSuccess()), "true");
        Utils.findAndReplaceSimpleElement(innerCount, element, "sendOnWarning", String.valueOf(notifier.isSendOnWarning()), "true");
        Utils.findAndReplaceSimpleElement(innerCount, element, "address", notifier.getAddress(), null);
        Utils.findAndReplaceProperties(innerCount, element, "configuration", notifier.getConfiguration());
    }

    protected void updateOrganization(Organization organization, IndentationCounter counter, Element element) {
        boolean shouldExist = organization != null;
        Element root = Utils.updateElement(counter, element, "organization", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "name", organization.getName(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "url", organization.getUrl(), null);
        }
    }

    protected void updateParent(Parent parent, IndentationCounter counter, Element element) {
        boolean shouldExist = parent != null;
        Element root = Utils.updateElement(counter, element, "parent", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "artifactId", parent.getArtifactId(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "groupId", parent.getGroupId(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "version", parent.getVersion(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "relativePath", parent.getRelativePath(), "../pom.xml");
        }
    }

    protected void updatePlugin(Plugin plugin, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "groupId", plugin.getGroupId(), "org.apache.maven.plugins");
        Utils.findAndReplaceSimpleElement(innerCount, element, "artifactId", plugin.getArtifactId(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "version", plugin.getVersion(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "extensions", plugin.getExtensions(), null);
        this.iteratePluginExecution(innerCount, element, plugin.getExecutions());
        this.iterateDependency(innerCount, element, plugin.getDependencies());
        Utils.findAndReplaceXpp3DOM(innerCount, element, "goals", (Xpp3Dom)plugin.getGoals());
        Utils.findAndReplaceSimpleElement(innerCount, element, "inherited", plugin.getInherited(), null);
        Utils.findAndReplaceXpp3DOM(innerCount, element, "configuration", (Xpp3Dom)plugin.getConfiguration());
    }

    protected void updatePluginExecution(PluginExecution pluginExecution, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "id", pluginExecution.getId(), "default");
        Utils.findAndReplaceSimpleElement(innerCount, element, "phase", pluginExecution.getPhase(), null);
        Utils.findAndReplaceSimpleLists(innerCount, element, pluginExecution.getGoals(), "goals", "goal");
        Utils.findAndReplaceSimpleElement(innerCount, element, "inherited", pluginExecution.getInherited(), null);
        Utils.findAndReplaceXpp3DOM(innerCount, element, "configuration", (Xpp3Dom)pluginExecution.getConfiguration());
    }

    protected void updatePluginManagement(PluginManagement pluginManagement, IndentationCounter counter, Element element) {
        boolean shouldExist = pluginManagement != null;
        Element root = Utils.updateElement(counter, element, "pluginManagement", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            this.iteratePlugin(innerCount, root, pluginManagement.getPlugins());
        }
    }

    protected void updatePrerequisites(Prerequisites prerequisites, IndentationCounter counter, Element element) {
        boolean shouldExist = prerequisites != null;
        Element root = Utils.updateElement(counter, element, "prerequisites", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "maven", prerequisites.getMaven(), "2.0");
        }
    }

    protected void updateProfile(Profile profile, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "id", profile.getId(), "default");
        this.updateActivation(profile.getActivation(), innerCount, element);
        this.updateBuildBase(profile.getBuild(), innerCount, element);
        Utils.findAndReplaceSimpleLists(innerCount, element, profile.getModules(), "modules", "module");
        this.updateDistributionManagement(profile.getDistributionManagement(), innerCount, element);
        Utils.findAndReplaceProperties(innerCount, element, "properties", profile.getProperties());
        this.updateDependencyManagement(profile.getDependencyManagement(), innerCount, element);
        this.iterateDependency(innerCount, element, profile.getDependencies());
        this.iterateRepository(innerCount, element, profile.getRepositories(), "repositories", "repository");
        this.iterateRepository(innerCount, element, profile.getPluginRepositories(), "pluginRepositories", "pluginRepository");
        Utils.findAndReplaceXpp3DOM(innerCount, element, "reports", (Xpp3Dom)profile.getReports());
        this.updateReporting(profile.getReporting(), innerCount, element);
    }

    protected void updateRelocation(Relocation relocation, IndentationCounter counter, Element element) {
        boolean shouldExist = relocation != null;
        Element root = Utils.updateElement(counter, element, "relocation", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "groupId", relocation.getGroupId(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "artifactId", relocation.getArtifactId(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "version", relocation.getVersion(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "message", relocation.getMessage(), null);
        }
    }

    protected void updateReportPlugin(ReportPlugin reportPlugin, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "groupId", reportPlugin.getGroupId(), "org.apache.maven.plugins");
        Utils.findAndReplaceSimpleElement(innerCount, element, "artifactId", reportPlugin.getArtifactId(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "version", reportPlugin.getVersion(), null);
        this.iterateReportSet(innerCount, element, reportPlugin.getReportSets());
        Utils.findAndReplaceSimpleElement(innerCount, element, "inherited", reportPlugin.getInherited(), null);
        Utils.findAndReplaceXpp3DOM(innerCount, element, "configuration", (Xpp3Dom)reportPlugin.getConfiguration());
    }

    protected void updateReportSet(ReportSet reportSet, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "id", reportSet.getId(), "default");
        Utils.findAndReplaceSimpleLists(innerCount, element, reportSet.getReports(), "reports", "report");
        Utils.findAndReplaceSimpleElement(innerCount, element, "inherited", reportSet.getInherited(), null);
        Utils.findAndReplaceXpp3DOM(innerCount, element, "configuration", (Xpp3Dom)reportSet.getConfiguration());
    }

    protected void updateReporting(Reporting reporting, IndentationCounter counter, Element element) {
        boolean shouldExist = reporting != null;
        Element root = Utils.updateElement(counter, element, "reporting", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "excludeDefaults", reporting.getExcludeDefaults(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "outputDirectory", reporting.getOutputDirectory(), null);
            this.iterateReportPlugin(innerCount, root, reporting.getPlugins());
        }
    }

    protected void updateRepository(Repository repository, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        this.updateRepositoryPolicy(repository.getReleases(), "releases", innerCount, element);
        this.updateRepositoryPolicy(repository.getSnapshots(), "snapshots", innerCount, element);
        Utils.findAndReplaceSimpleElement(innerCount, element, "id", repository.getId(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "name", repository.getName(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "url", repository.getUrl(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "layout", repository.getLayout(), "default");
    }

    protected void updateRepositoryPolicy(RepositoryPolicy repositoryPolicy, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = repositoryPolicy != null;
        Element root = Utils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "enabled", repositoryPolicy.getEnabled(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "updatePolicy", repositoryPolicy.getUpdatePolicy(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "checksumPolicy", repositoryPolicy.getChecksumPolicy(), null);
        }
    }

    protected void updateResource(Resource resource, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "targetPath", resource.getTargetPath(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "filtering", resource.getFiltering(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "directory", resource.getDirectory(), null);
        Utils.findAndReplaceSimpleLists(innerCount, element, resource.getIncludes(), "includes", "include");
        Utils.findAndReplaceSimpleLists(innerCount, element, resource.getExcludes(), "excludes", "exclude");
    }

    protected void updateScm(Scm scm, IndentationCounter counter, Element element) {
        boolean shouldExist = scm != null;
        Element root = Utils.updateElement(counter, element, "scm", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "connection", scm.getConnection(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "developerConnection", scm.getDeveloperConnection(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "tag", scm.getTag(), "HEAD");
            Utils.findAndReplaceSimpleElement(innerCount, root, "url", scm.getUrl(), null);
        }
    }

    protected void updateSite(Site site, IndentationCounter counter, Element element) {
        boolean shouldExist = site != null;
        Element root = Utils.updateElement(counter, element, "site", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "id", site.getId(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "name", site.getName(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "url", site.getUrl(), null);
        }
    }

    protected void update(Model source, IndentationCounter indentationCounter, Element rootElement) {
        this.updateModel(source, indentationCounter, rootElement);
    }

    private void removeExisting(Element element, String tag) {
        if (element != null) {
            this.logger.debug("Removing pre-existing for {}", (Object)element);
            Iterator elIt = element.getChildren(tag, element.getNamespace()).iterator();
            while (elIt.hasNext()) {
                elIt.next();
                elIt.remove();
            }
        }
    }
}

