/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.common.jdom;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.ActivationFile;
import org.apache.maven.settings.ActivationOS;
import org.apache.maven.settings.ActivationProperty;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.commonjava.maven.ext.common.jdom.IndentationCounter;
import org.commonjava.maven.ext.common.jdom.Utils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.UncheckedJDOMFactory;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class JDOMSettingsConverter {
    private final JDOMFactory factory;
    private final Format format = Format.getRawFormat();

    public JDOMSettingsConverter() {
        this.factory = new UncheckedJDOMFactory();
    }

    public final void write(Settings source, File target, String intro, String outtro) throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder();
        builder.setExpandEntities(false);
        Document document = target.length() > 0L ? builder.build(target) : builder.build((Reader)new StringReader("<settings xmlns=\"http://maven.apache.org/SETTINGS/1.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/SETTINGS/1.0.0 http://maven.apache.org/xsd/settings-1.0.0.xsd\"></settings>"));
        this.format.setTextMode(Format.TextMode.PRESERVE);
        this.format.setOmitEncoding(false);
        this.format.setOmitDeclaration(false);
        this.format.setExpandEmptyElements(false);
        this.format.setEncoding(StringUtils.isEmpty((String)source.getModelEncoding()) ? StandardCharsets.UTF_8.toString() : source.getModelEncoding());
        this.update(source, new IndentationCounter(0), document.getRootElement());
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(this.format);
        try (Writer settingsWriter = WriterFactory.newWriter((File)target, (String)this.format.getEncoding());){
            if (StringUtils.isNotBlank((String)intro)) {
                settingsWriter.write(intro);
                outputter.output(document.getRootElement(), settingsWriter);
                settingsWriter.write(outtro);
            } else {
                outputter.output(document, settingsWriter);
            }
            settingsWriter.flush();
        }
    }

    public void setLineSeparator(String separator) {
        this.format.setLineSeparator(separator);
    }

    protected void iterateMirror(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = Utils.updateElement(counter, parent, "mirrors", shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("mirror", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Mirror value = (Mirror)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("mirror", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateMirror(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateProfile(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = Utils.updateElement(counter, parent, "profiles", shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("profile", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Profile value = (Profile)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("profile", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateProfile(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateProxy(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = Utils.updateElement(counter, parent, "proxies", shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("proxy", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Proxy value = (Proxy)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("proxy", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateProxy(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateRepository(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = Utils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Repository value = (Repository)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateRepository(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateServer(IndentationCounter counter, Element parent, Collection list) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = Utils.updateElement(counter, parent, "servers", shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren("server", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Server value = (Server)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("server", element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateServer(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void updateActivation(Activation activation, IndentationCounter counter, Element element) {
        boolean shouldExist = activation != null;
        Element root = Utils.updateElement(counter, element, "activation", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "activeByDefault", String.valueOf(activation.isActiveByDefault()), "false");
            Utils.findAndReplaceSimpleElement(innerCount, root, "jdk", activation.getJdk(), null);
            this.updateActivationOS(activation.getOs(), innerCount, root);
            this.updateActivationProperty(activation.getProperty(), innerCount, root);
            this.updateActivationFile(activation.getFile(), innerCount, root);
        }
    }

    protected void updateActivationFile(ActivationFile activationFile, IndentationCounter counter, Element element) {
        boolean shouldExist = activationFile != null;
        Element root = Utils.updateElement(counter, element, "file", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "missing", activationFile.getMissing(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "exists", activationFile.getExists(), null);
        }
    }

    protected void updateActivationOS(ActivationOS activationOS, IndentationCounter counter, Element element) {
        boolean shouldExist = activationOS != null;
        Element root = Utils.updateElement(counter, element, "os", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "name", activationOS.getName(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "family", activationOS.getFamily(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "arch", activationOS.getArch(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "version", activationOS.getVersion(), null);
        }
    }

    protected void updateActivationProperty(ActivationProperty activationProperty, IndentationCounter counter, Element element) {
        boolean shouldExist = activationProperty != null;
        Element root = Utils.updateElement(counter, element, "property", shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "name", activationProperty.getName(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "value", activationProperty.getValue(), null);
        }
    }

    protected void updateMirror(Mirror mirror, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "mirrorOf", mirror.getMirrorOf(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "name", mirror.getName(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "url", mirror.getUrl(), null);
        if (element.getNamespace().getURI().equals("http://maven.apache.org/SETTINGS/1.1.0")) {
            Utils.findAndReplaceSimpleElement(innerCount, element, "layout", mirror.getLayout(), null);
            Utils.findAndReplaceSimpleElement(innerCount, element, "mirrorOfLayouts", mirror.getMirrorOfLayouts(), "default,legacy");
        }
        Utils.findAndReplaceSimpleElement(innerCount, element, "id", mirror.getId(), "default");
    }

    protected void updateProfile(Profile profile, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        this.updateActivation(profile.getActivation(), innerCount, element);
        Utils.findAndReplaceProperties(innerCount, element, "properties", profile.getProperties());
        this.iterateRepository(innerCount, element, profile.getRepositories(), "repositories", "repository");
        this.iterateRepository(innerCount, element, profile.getPluginRepositories(), "pluginRepositories", "pluginRepository");
        Utils.findAndReplaceSimpleElement(innerCount, element, "id", profile.getId(), "default");
    }

    protected void updateProxy(Proxy proxy, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "active", String.valueOf(proxy.isActive()), "true");
        Utils.findAndReplaceSimpleElement(innerCount, element, "protocol", proxy.getProtocol(), "http");
        Utils.findAndReplaceSimpleElement(innerCount, element, "username", proxy.getUsername(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "password", proxy.getPassword(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "port", String.valueOf(proxy.getPort()), "8080");
        Utils.findAndReplaceSimpleElement(innerCount, element, "host", proxy.getHost(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "nonProxyHosts", proxy.getNonProxyHosts(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "id", proxy.getId(), "default");
    }

    protected void updateRepository(Repository repository, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        this.updateRepositoryPolicy(repository.getReleases(), "releases", innerCount, element);
        this.updateRepositoryPolicy(repository.getSnapshots(), "snapshots", innerCount, element);
        Utils.findAndReplaceSimpleElement(innerCount, element, "id", repository.getId(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "name", repository.getName(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "url", repository.getUrl(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "layout", repository.getLayout(), "default");
    }

    protected void updateRepositoryPolicy(RepositoryPolicy repositoryPolicy, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = repositoryPolicy != null;
        Element root = Utils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            Utils.findAndReplaceSimpleElement(innerCount, root, "enabled", String.valueOf(repositoryPolicy.isEnabled()), "true");
            Utils.findAndReplaceSimpleElement(innerCount, root, "updatePolicy", repositoryPolicy.getUpdatePolicy(), null);
            Utils.findAndReplaceSimpleElement(innerCount, root, "checksumPolicy", repositoryPolicy.getChecksumPolicy(), null);
        }
    }

    protected void updateServer(Server server, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "username", server.getUsername(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "password", server.getPassword(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "privateKey", server.getPrivateKey(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "passphrase", server.getPassphrase(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "filePermissions", server.getFilePermissions(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "directoryPermissions", server.getDirectoryPermissions(), null);
        Utils.findAndReplaceXpp3DOM(innerCount, element, "configuration", (Xpp3Dom)server.getConfiguration());
        Utils.findAndReplaceSimpleElement(innerCount, element, "id", server.getId(), "default");
    }

    protected void updateSettings(Settings settings, IndentationCounter counter, Element element) {
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        Utils.findAndReplaceSimpleElement(innerCount, element, "localRepository", settings.getLocalRepository(), null);
        Utils.findAndReplaceSimpleElement(innerCount, element, "interactiveMode", String.valueOf(settings.isInteractiveMode()), "true");
        Utils.findAndReplaceSimpleElement(innerCount, element, "usePluginRegistry", String.valueOf(settings.isUsePluginRegistry()), "false");
        Utils.findAndReplaceSimpleElement(innerCount, element, "offline", !settings.isOffline() ? null : String.valueOf(settings.isOffline()), "false");
        this.iterateProxy(innerCount, element, settings.getProxies());
        this.iterateServer(innerCount, element, settings.getServers());
        this.iterateMirror(innerCount, element, settings.getMirrors());
        this.iterateProfile(innerCount, element, settings.getProfiles());
        Utils.findAndReplaceSimpleLists(innerCount, element, settings.getActiveProfiles(), "activeProfiles", "activeProfile");
        Utils.findAndReplaceSimpleLists(innerCount, element, settings.getPluginGroups(), "pluginGroups", "pluginGroup");
    }

    protected void update(Settings source, IndentationCounter indentationCounter, Element rootElement) {
        this.updateSettings(source, indentationCounter, rootElement);
    }
}

