/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.common.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.commonjava.maven.ext.common.ManipulationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManifestUtils {
    private static final Logger logger = LoggerFactory.getLogger(ManifestUtils.class);

    public static String getManifestInformation(Class<?> target) throws ManipulationException {
        String result;
        block10: {
            result = "";
            if (target == null) {
                throw new ManipulationException("No target specified.", new Object[0]);
            }
            try {
                CodeSource cs = target.getProtectionDomain().getCodeSource();
                if (cs == null) {
                    logger.debug("Unable to retrieve manifest for {} as CodeSource was null for the protection domain ({})", target, (Object)target.getProtectionDomain());
                    break block10;
                }
                URL jarUrl = cs.getLocation();
                if (new File(jarUrl.getPath()).isDirectory()) {
                    logger.debug("Unable to retrieve manifest for {} as location is a directory not a jar ({})", target, (Object)jarUrl.getPath());
                    break block10;
                }
                try (JarInputStream jarStream = new JarInputStream(jarUrl.openStream());){
                    Manifest manifest = jarStream.getManifest();
                    result = manifest.getMainAttributes().getValue("Implementation-Version");
                    result = result + " ( SHA: " + manifest.getMainAttributes().getValue("Scm-Revision") + " )";
                }
            }
            catch (IOException e) {
                throw new ManipulationException("Error retrieving information from manifest", e);
            }
        }
        return result;
    }

    private ManifestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

