/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.common.util;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.commonjava.maven.ext.common.ManipulationException;

public class PropertyInterpolator {
    private final StringSearchInterpolator interp = new StringSearchInterpolator();
    private final PrefixAwareRecursionInterceptor ri;

    public PropertyInterpolator(Properties props, Object objectValueSource) {
        if (props != null) {
            this.interp.addValueSource((ValueSource)new PropertiesBasedValueSource(props));
        }
        List<String> prefixes = Arrays.asList("pom", "project");
        this.ri = new PrefixAwareRecursionInterceptor(prefixes, true);
        this.interp.addValueSource((ValueSource)new PrefixedObjectValueSource(prefixes, objectValueSource, true));
    }

    public String interp(String value) throws ManipulationException {
        try {
            return this.interp.interpolate(value, (RecursionInterceptor)this.ri);
        }
        catch (InterpolationException e) {
            throw new ManipulationException("Failed to interpolate: {}. Reason: {}", new Object[]{value, e.getMessage(), e});
        }
    }
}

