/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.ByteSourceJsonBootstrapper;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Named;
import javax.inject.Singleton;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.io.FileIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class JSONIO {
    private static final Logger logger = LoggerFactory.getLogger(JSONIO.class);
    private File jsonFile;
    private JsonEncoding encoding;
    private Charset charset;
    private String eol;

    public static JsonEncoding detectEncoding(File jsonFile) throws ManipulationException {
        JsonEncoding jsonEncoding;
        FileInputStream in = new FileInputStream(jsonFile);
        try {
            byte[] inputBuffer = new byte[4];
            in.read(inputBuffer);
            IOContext ctxt = new IOContext(new BufferRecycler(), null, false);
            ByteSourceJsonBootstrapper strapper = new ByteSourceJsonBootstrapper(ctxt, inputBuffer, 0, 4);
            JsonEncoding encoding = strapper.detectEncoding();
            logger.debug("Detected JSON encoding {} for file {}", (Object)encoding, (Object)jsonFile);
            jsonEncoding = encoding;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error("Unable to detect charset for file: {}", (Object)jsonFile, (Object)e);
                throw new ManipulationException("Unable to detect charset for file {}", new Object[]{jsonFile, e});
            }
        }
        in.close();
        return jsonEncoding;
    }

    public JsonEncoding getEncoding() throws ManipulationException {
        return this.encoding;
    }

    public Charset getCharset() throws ManipulationException {
        return this.charset;
    }

    public String detectEOL(File jsonFile) throws ManipulationException {
        if (this.charset == null) {
            JSONIO.detectEncoding(jsonFile);
        }
        if (!StandardCharsets.UTF_8.equals(this.charset)) {
            return new String(System.lineSeparator().getBytes(Charset.forName(this.charset.name())), this.charset);
        }
        String lf = null;
        try {
            lf = FileIO.determineEOL(jsonFile).value();
            if (logger.isDebugEnabled()) {
                logger.debug("Detected JSON linefeed {} for file {}", (Object)lf.replace("\r", "\\r").replace("\n", "\\n"), (Object)jsonFile);
            }
        }
        catch (ManipulationException e) {
            logger.error("Unable to detect eol for file: {}", (Object)jsonFile, (Object)e);
            throw new ManipulationException("Unable to detect eol for file {}", new Object[]{jsonFile, e});
        }
        return lf;
    }

    public String getEOL() throws ManipulationException {
        return this.eol;
    }

    public DocumentContext parseJSON(File jsonFile) throws ManipulationException {
        DocumentContext doc;
        if (jsonFile == null || !jsonFile.exists()) {
            throw new ManipulationException("JSON File not found", new Object[0]);
        }
        this.encoding = JSONIO.detectEncoding(jsonFile);
        this.charset = Charset.forName(this.encoding.getJavaName());
        this.jsonFile = jsonFile;
        this.eol = this.detectEOL(jsonFile);
        try (FileInputStream in = new FileInputStream(jsonFile);){
            Configuration conf = Configuration.builder().options(new Option[]{Option.ALWAYS_RETURN_LIST}).build();
            doc = JsonPath.using((Configuration)conf).parse((InputStream)in, this.charset.name());
        }
        catch (IOException e) {
            logger.error("Unable to parse JSON File", (Throwable)e);
            throw new ManipulationException("Unable to parse JSON File", (Throwable)e);
        }
        return doc;
    }

    public void writeJSON(File target, DocumentContext contents) throws ManipulationException {
        try {
            MyPrettyPrinter dpp = new MyPrettyPrinter(this.getCharset());
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = contents.jsonString();
            String pretty = mapper.writer((PrettyPrinter)dpp).writeValueAsString(mapper.readValue(jsonString, Object.class));
            Charset cs = this.getCharset();
            FileOutputStream fileOutputStream = new FileOutputStream(target);
            try (OutputStreamWriter p = new OutputStreamWriter((OutputStream)fileOutputStream, cs);){
                p.write(pretty);
                p.append(this.getEOL());
            }
        }
        catch (IOException e) {
            logger.error("Unable to write JSON string:  ", (Throwable)e);
            throw new ManipulationException("Unable to write JSON string", (Throwable)e);
        }
    }

    private class MyPrettyPrinter
    extends DefaultPrettyPrinter {
        private Charset charset;

        public MyPrettyPrinter(Charset charset) throws ManipulationException {
            super((SerializableString)DEFAULT_ROOT_VALUE_SEPARATOR);
            this.charset = StandardCharsets.UTF_8;
            this.charset = charset;
            this._objectIndenter = new DefaultIndenter("  ", JSONIO.this.getEOL());
        }

        public MyPrettyPrinter(MyPrettyPrinter base) {
            super((DefaultPrettyPrinter)base, base._rootSeparator);
            this.charset = StandardCharsets.UTF_8;
        }

        public DefaultPrettyPrinter createInstance() {
            return new MyPrettyPrinter(this);
        }

        public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
            String s = this._spacesInObjectEntries ? ": " : ":";
            jg.writeRaw(new String(s.getBytes(), this.charset));
        }
    }
}

