/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.commonjava.maven.ext.common.ManipulationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Named
@Singleton
public class XMLIO {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DocumentBuilder builder;
    private final Transformer transformer;

    public XMLIO() {
        try {
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.transformer = TransformerFactory.newInstance().newTransformer();
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
            this.transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (ParserConfigurationException e) {
            this.logger.error("Unable to create new DocumentBuilder", (Throwable)e);
            throw new RuntimeException("Unable to create new DocumentBuilder");
        }
        catch (TransformerConfigurationException e) {
            this.logger.error("Unable to create new Transformer", (Throwable)e);
            throw new RuntimeException("Unable to create new Transformer");
        }
    }

    public Document parseXML(File xmlFile) throws ManipulationException {
        Document doc;
        if (xmlFile == null || !xmlFile.exists()) {
            this.logger.error("Unable to locate XML File {}", (Object)xmlFile);
            throw new ManipulationException("XML file ({}) not found.", new Object[]{xmlFile});
        }
        try {
            doc = this.builder.parse(xmlFile);
        }
        catch (IOException | SAXException e) {
            this.logger.error("Unable to parse XML File", (Throwable)e);
            throw new ManipulationException("Unable to parse XML File", (Throwable)e);
        }
        return doc;
    }

    public void writeXML(File target, Document contents) throws ManipulationException {
        try {
            String result = this.convert(contents);
            result = result.replaceFirst("(?s)(<!--.*-->)<", "$1\n<");
            FileUtils.writeStringToFile((File)target, (String)result, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.logger.error("XML transformer failure", (Throwable)e);
            throw new ManipulationException("XML transformer failure", (Throwable)e);
        }
    }

    public String convert(Document contents) throws ManipulationException {
        StringWriter outWriter = new StringWriter();
        try {
            StreamResult streamResult = new StreamResult(outWriter);
            this.transformer.transform(new DOMSource(contents), streamResult);
        }
        catch (TransformerException e) {
            this.logger.error("XML transformer failure", (Throwable)e);
            throw new ManipulationException("XML transformer failure", (Throwable)e);
        }
        return outWriter.toString();
    }
}

