/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleTypeAndClassifier;
import org.commonjava.maven.atlas.ident.ref.TypeAndClassifier;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.TransferManager;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.maven.ArtifactManager;
import org.commonjava.maven.galley.maven.ArtifactRules;
import org.commonjava.maven.galley.maven.model.ArtifactBatch;
import org.commonjava.maven.galley.maven.model.ProjectVersionRefLocation;
import org.commonjava.maven.galley.maven.spi.type.TypeMapper;
import org.commonjava.maven.galley.maven.spi.version.VersionResolver;
import org.commonjava.maven.galley.maven.util.ArtifactPathUtils;
import org.commonjava.maven.galley.maven.version.LatestVersionSelectionStrategy;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.ListingResult;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Resource;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferBatch;
import org.commonjava.maven.galley.model.VirtualResource;
import org.commonjava.maven.galley.spi.transport.LocationExpander;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ArtifactManagerImpl
implements ArtifactManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private TransferManager transferManager;
    @Inject
    private LocationExpander expander;
    @Inject
    private TypeMapper mapper;
    @Inject
    private VersionResolver versionResolver;

    protected ArtifactManagerImpl() {
    }

    public ArtifactManagerImpl(TransferManager transferManager, LocationExpander expander, TypeMapper mapper, VersionResolver versionResolver) {
        this.transferManager = transferManager;
        this.expander = expander;
        this.mapper = mapper;
        this.versionResolver = versionResolver;
    }

    @Override
    public boolean delete(Location location, ArtifactRef ref) throws TransferException {
        return this.delete(location, ref, new EventMetadata());
    }

    @Override
    public boolean delete(Location location, ArtifactRef ref, EventMetadata eventMetadata) throws TransferException {
        String path = ArtifactPathUtils.formatArtifactPath((ProjectVersionRef)ref, this.mapper);
        return this.transferManager.deleteAll(new VirtualResource(this.expander.expand(new Location[]{location}), new String[]{path}), eventMetadata);
    }

    @Override
    public boolean deleteAll(List<? extends Location> locations, ArtifactRef ref) throws TransferException {
        return this.deleteAll(locations, ref, new EventMetadata());
    }

    @Override
    public boolean deleteAll(List<? extends Location> locations, ArtifactRef ref, EventMetadata eventMetadata) throws TransferException {
        return this.transferManager.deleteAll(new VirtualResource(this.expander.expand(locations), new String[]{ArtifactPathUtils.formatArtifactPath((ProjectVersionRef)ref, this.mapper)}), eventMetadata);
    }

    @Override
    public Transfer retrieve(Location location, ArtifactRef ref) throws TransferException {
        return this.retrieve(location, ref, new EventMetadata());
    }

    @Override
    public Transfer retrieve(Location location, ArtifactRef ref, EventMetadata eventMetadata) throws TransferException {
        VirtualResource virt = this.resolveFirstVirtualResource(Collections.singletonList(location), ref, eventMetadata);
        return this.transferManager.retrieveFirst(virt, eventMetadata);
    }

    @Override
    public List<Transfer> retrieveAll(List<? extends Location> locations, ArtifactRef ref) throws TransferException {
        return this.retrieveAll(locations, ref, new EventMetadata());
    }

    @Override
    public List<Transfer> retrieveAll(List<? extends Location> locations, ArtifactRef ref, EventMetadata eventMetadata) throws TransferException {
        VirtualResource virt = this.resolveAllVirtualResource(locations, ref, eventMetadata);
        if (virt == null) {
            return Collections.emptyList();
        }
        return this.transferManager.retrieveAll(virt, eventMetadata);
    }

    @Override
    public Transfer retrieveFirst(List<? extends Location> locations, ArtifactRef ref) throws TransferException {
        return this.retrieveFirst(locations, ref, new EventMetadata());
    }

    @Override
    public Transfer retrieveFirst(List<? extends Location> locations, ArtifactRef ref, EventMetadata eventMetadata) throws TransferException {
        VirtualResource virt = this.resolveFirstVirtualResource(locations, ref, eventMetadata);
        return this.transferManager.retrieveFirst(virt, eventMetadata);
    }

    @Override
    public Transfer store(Location location, ArtifactRef ref, InputStream stream) throws TransferException {
        return this.store(location, ref, stream, new EventMetadata());
    }

    @Override
    public Transfer store(Location location, ArtifactRef ref, InputStream stream, EventMetadata eventMetadata) throws TransferException {
        List locations = this.expander.expand(new Location[]{location});
        Location selected = ArtifactRules.selectStorageLocation(locations);
        if (selected == null) {
            return null;
        }
        ConcreteResource resource = new ConcreteResource(selected, new String[]{ArtifactPathUtils.formatArtifactPath((ProjectVersionRef)ref, this.mapper)});
        ArtifactRules.checkStorageAuthorization(resource);
        return this.transferManager.store(resource, stream, eventMetadata);
    }

    @Override
    public boolean publish(Location location, ArtifactRef ref, InputStream stream, long length) throws TransferException {
        return this.transferManager.publish(new ConcreteResource(location, new String[]{ArtifactPathUtils.formatArtifactPath((ProjectVersionRef)ref, this.mapper)}), stream, length);
    }

    @Override
    public boolean publish(Location location, ArtifactRef ref, InputStream stream, long length, EventMetadata metadata) throws TransferException {
        return this.transferManager.publish(new ConcreteResource(location, new String[]{ArtifactPathUtils.formatArtifactPath((ProjectVersionRef)ref, this.mapper)}), stream, length, metadata);
    }

    @Override
    public Map<TypeAndClassifier, ConcreteResource> listAvailableArtifacts(Location location, ProjectVersionRef ref) throws TransferException {
        return this.listAvailableArtifacts(location, ref, new EventMetadata());
    }

    @Override
    public Map<TypeAndClassifier, ConcreteResource> listAvailableArtifacts(Location location, ProjectVersionRef ref, EventMetadata metadata) throws TransferException {
        List listingResults = this.transferManager.listAll(new VirtualResource(this.expander.expand(new Location[]{location}), new String[]{ArtifactPathUtils.formatArtifactPath(ref.asProjectVersionRef(), this.mapper)}), metadata);
        if (listingResults == null || listingResults.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<TypeAndClassifier, ConcreteResource> result = new LinkedHashMap<TypeAndClassifier, ConcreteResource>();
        String prefix = String.format("%s-%s", ref.getArtifactId(), ref.getVersionString());
        for (ListingResult listingResult : listingResults) {
            for (String fname : listingResult.getListing()) {
                if (!fname.startsWith(prefix)) continue;
                String remainder = fname.substring(prefix.length());
                String classifier = null;
                String type = null;
                if (remainder.startsWith("-")) {
                    int extPos = remainder.indexOf(46);
                    if (extPos < 2) {
                        this.logger.warn("Listing found unparsable filename: '{}' from: {}. Skipping", (Object)fname, (Object)location);
                        continue;
                    }
                    classifier = remainder.substring(1, extPos);
                    type = remainder.substring(extPos + 1);
                } else if (remainder.startsWith(".")) {
                    type = remainder.substring(1);
                }
                ConcreteResource res = listingResult.getResource().getChild(fname);
                result.put((TypeAndClassifier)new SimpleTypeAndClassifier(type, classifier), res);
            }
        }
        return result;
    }

    @Override
    public ProjectVersionRef resolveVariableVersion(Location location, ProjectVersionRef ref) throws TransferException {
        return this.resolveVariableVersion(location, ref, new EventMetadata());
    }

    @Override
    public ProjectVersionRef resolveVariableVersion(Location location, ProjectVersionRef ref, EventMetadata eventMetadata) throws TransferException {
        return this.resolveVariableVersion(Collections.singletonList(location), ref, eventMetadata);
    }

    @Override
    public ProjectVersionRef resolveVariableVersion(List<? extends Location> locations, ProjectVersionRef ref) throws TransferException {
        return this.resolveVariableVersion(locations, ref, new EventMetadata());
    }

    @Override
    public ProjectVersionRef resolveVariableVersion(List<? extends Location> locations, ProjectVersionRef ref, EventMetadata eventMetadata) throws TransferException {
        return this.versionResolver.resolveFirstMatchVariableVersion(locations, ref, LatestVersionSelectionStrategy.INSTANCE, eventMetadata);
    }

    @Override
    public ConcreteResource checkExistence(Location location, ArtifactRef ref) throws TransferException {
        return this.checkExistence(location, ref, new EventMetadata());
    }

    @Override
    public ConcreteResource checkExistence(Location location, ArtifactRef ref, EventMetadata eventMetadata) throws TransferException {
        VirtualResource virt = this.resolveAllVirtualResource(Collections.singletonList(location), ref, eventMetadata);
        if (virt == null) {
            return null;
        }
        return this.transferManager.findFirstExisting(virt);
    }

    @Override
    public List<ConcreteResource> findAllExisting(List<? extends Location> locations, ArtifactRef ref) throws TransferException {
        return this.findAllExisting(locations, ref, new EventMetadata());
    }

    @Override
    public List<ConcreteResource> findAllExisting(List<? extends Location> locations, ArtifactRef ref, EventMetadata eventMetadata) throws TransferException {
        VirtualResource virt = this.resolveAllVirtualResource(locations, ref, eventMetadata);
        return this.transferManager.findAllExisting(virt);
    }

    @Override
    public ArtifactBatch batchRetrieve(ArtifactBatch batch) throws TransferException {
        return this.batchRetrieve(batch, new EventMetadata());
    }

    @Override
    public ArtifactBatch batchRetrieve(ArtifactBatch batch, EventMetadata eventMetadata) throws TransferException {
        this.resolveArtifactMappings(batch, eventMetadata);
        return (ArtifactBatch)this.transferManager.batchRetrieve((TransferBatch)batch, eventMetadata);
    }

    @Override
    public ArtifactBatch batchRetrieveAll(ArtifactBatch batch) throws TransferException {
        return this.batchRetrieveAll(batch, new EventMetadata());
    }

    @Override
    public ArtifactBatch batchRetrieveAll(ArtifactBatch batch, EventMetadata eventMetadata) throws TransferException {
        this.resolveArtifactMappings(batch, eventMetadata);
        return (ArtifactBatch)this.transferManager.batchRetrieveAll((TransferBatch)batch, eventMetadata);
    }

    private void resolveArtifactMappings(ArtifactBatch batch, EventMetadata eventMetadata) throws TransferException {
        HashMap<ArtifactRef, Resource> resources = new HashMap<ArtifactRef, Resource>(batch.size());
        for (ArtifactRef artifact : batch) {
            VirtualResource virt = this.resolveFirstVirtualResource(batch.getLocations(artifact), artifact, eventMetadata);
            resources.put(artifact, (Resource)virt);
        }
        batch.setArtifactToResourceMapping(resources);
    }

    private VirtualResource resolveAllVirtualResource(List<? extends Location> locations, ArtifactRef ref, EventMetadata eventMetadata) throws TransferException {
        locations = this.expander.expand(locations);
        this.logger.debug("Locations expanded to: {} for artifact: {}", (Object)locations, (Object)ref);
        VirtualResource virt = new VirtualResource(locations, new String[]{ArtifactPathUtils.formatArtifactPath((ProjectVersionRef)ref, this.mapper)});
        if (ref.isVariableVersion()) {
            List<ProjectVersionRefLocation> resolved = this.resolveAllVariableVersions(locations, ref, eventMetadata);
            if (resolved != null && !resolved.isEmpty()) {
                ArrayList<ConcreteResource> resources = new ArrayList<ConcreteResource>(resolved.size());
                for (ProjectVersionRefLocation result : resolved) {
                    resources.add(new ConcreteResource(result.getLocation(), new String[]{ArtifactPathUtils.formatArtifactPath((ProjectVersionRef)ref, this.mapper)}));
                }
                virt = new VirtualResource(resources);
            } else {
                return null;
            }
        }
        return virt;
    }

    private VirtualResource resolveFirstVirtualResource(List<? extends Location> locations, ArtifactRef ref, EventMetadata eventMetadata) throws TransferException {
        ProjectVersionRefLocation resolved;
        locations = this.expander.expand(locations);
        if (ref.isVariableVersion() && (resolved = this.resolveSingleVariableVersion((List<? extends Location>)locations, ref, eventMetadata)) != null) {
            locations = Collections.singletonList(resolved.getLocation());
            ref = (ArtifactRef)resolved.getRef();
        }
        return new VirtualResource(this.expander.expand((Collection)locations), new String[]{ArtifactPathUtils.formatArtifactPath((ProjectVersionRef)ref, this.mapper)});
    }

    private ProjectVersionRefLocation resolveSingleVariableVersion(List<? extends Location> locations, ArtifactRef ref, EventMetadata eventMetadata) throws TransferException {
        return this.versionResolver.resolveFirstMatchVariableVersionLocation(locations, (ProjectVersionRef)ref, LatestVersionSelectionStrategy.INSTANCE, eventMetadata);
    }

    private List<ProjectVersionRefLocation> resolveAllVariableVersions(List<? extends Location> locations, ArtifactRef ref, EventMetadata eventMetadata) throws TransferException {
        return this.versionResolver.resolveAllVariableVersionLocations(locations, ref, LatestVersionSelectionStrategy.INSTANCE, eventMetadata);
    }
}

