/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.commonjava.maven.atlas.ident.DependencyScope;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleVersionlessArtifactRef;
import org.commonjava.maven.atlas.ident.ref.VersionlessArtifactRef;
import org.commonjava.maven.atlas.ident.version.InvalidVersionSpecificationException;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.MavenGAVView;
import org.commonjava.maven.galley.maven.model.view.MavenGAView;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.commonjava.maven.galley.maven.model.view.OriginInfo;
import org.commonjava.maven.galley.maven.model.view.ProjectRefView;
import org.commonjava.maven.galley.maven.model.view.XmlNodeInfo;
import org.w3c.dom.Element;

public class DependencyView
extends MavenGAVView {
    private static final String S = "scope";
    private static final String OPTIONAL = "optional";
    private static final String EXCLUSIONS = "exclusions/exclusion";
    private String classifier;
    private String type;
    private DependencyScope scope;
    private Boolean optional;
    private Set<ProjectRefView> exclusions;

    public DependencyView(MavenPomView pomView, Element element, OriginInfo originInfo) {
        super(pomView, element, originInfo, "dependencyManagement/dependencies/dependency");
    }

    public boolean isManaged() throws GalleyMavenException {
        return ((MavenPomView)this.xmlView).resolveXPathToNodeFrom(this.elementContext, "ancestor::dependencyManagement", true) != null;
    }

    public synchronized String getClassifier() {
        if (this.classifier == null) {
            this.classifier = this.getValue("classifier");
        }
        return this.classifier;
    }

    public synchronized String getRawType() {
        if (this.type == null) {
            this.type = this.getValue("type");
        }
        return this.type;
    }

    public synchronized String getType() {
        String type = this.getRawType();
        return type == null ? "jar" : type;
    }

    public synchronized DependencyScope getScope() throws GalleyMavenException {
        if (this.scope == null) {
            String s = this.getValueWithManagement(S);
            this.scope = DependencyScope.getScope((String)s);
        }
        return this.scope == null ? DependencyScope.compile : this.scope;
    }

    public synchronized boolean isOptional() {
        if (this.optional == null) {
            String val = this.getValue(OPTIONAL);
            this.optional = val != null && Boolean.parseBoolean(val);
        }
        return this.optional;
    }

    public synchronized Set<ProjectRefView> getExclusions() throws GalleyMavenException {
        List<XmlNodeInfo> nodes;
        if (this.exclusions == null && (nodes = this.getFirstNodesWithManagement(EXCLUSIONS)) != null) {
            HashSet<ProjectRefView> exclusions = new HashSet<ProjectRefView>();
            for (XmlNodeInfo node : nodes) {
                exclusions.add(new MavenGAView((MavenPomView)this.xmlView, (Element)node.getNode(), node.getOriginInfo()));
            }
            this.exclusions = exclusions;
        }
        return this.exclusions;
    }

    @Override
    protected String getManagedViewQualifierFragment() {
        StringBuilder sb = new StringBuilder();
        sb.append("ext:resolve(").append("groupId").append("/text()").append(")").append("=\"").append(this.getGroupId()).append("\"").append(" and ").append("ext:resolve(").append("artifactId").append("/text()").append(")").append("=\"").append(this.getArtifactId()).append("\"");
        String cls = this.getClassifier();
        if (cls != null) {
            sb.append(" and ").append("ext:resolve(").append("classifier").append("/text()").append(")").append("=\"").append(cls).append("\"");
        } else {
            sb.append(" and ").append(" not(").append("classifier").append(")");
        }
        String type = this.getRawType();
        if (type != null) {
            sb.append(" and ").append("ext:resolve(").append("type").append("/text()").append(")").append("=\"").append(type).append("\"");
        } else {
            sb.append(" and ").append("(").append(" not(").append("type").append(")").append(" or ").append("ext:resolve(").append("type").append("/text()").append(")").append("=\"").append("jar").append("\"").append(")");
        }
        return sb.toString();
    }

    public ArtifactRef asArtifactRef() throws GalleyMavenException {
        try {
            return new SimpleArtifactRef(this.asProjectVersionRef(), this.getType(), this.getClassifier());
        }
        catch (IllegalArgumentException | InvalidVersionSpecificationException e) {
            String classifier = this.getClassifier();
            throw new GalleyMavenException("Cannot render SimpleArtifactRef: {}:{}:{}:{}{}. Reason: {}", e, this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getRawType(), classifier == null ? "" : ":" + classifier, e.getMessage());
        }
    }

    public VersionlessArtifactRef asVersionlessArtifactRef() throws GalleyMavenException {
        try {
            return new SimpleVersionlessArtifactRef(this.asProjectRef(), this.getType(), this.getClassifier());
        }
        catch (IllegalArgumentException | InvalidVersionSpecificationException e) {
            String classifier = this.getClassifier();
            throw new GalleyMavenException("Cannot render VersionlessArtifactRef: {}:{}:{}{}. Reason: {}", e, this.getGroupId(), this.getArtifactId(), this.getRawType(), classifier == null ? "" : ":" + classifier, e.getMessage());
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        String artifactId = this.getArtifactId();
        String groupId = this.getGroupId();
        String type = this.getType();
        String classifier = this.getClassifier();
        result = 31 * result + (artifactId == null ? 0 : artifactId.hashCode());
        result = 31 * result + (groupId == null ? 0 : groupId.hashCode());
        result = 31 * result + (type.equals("jar") ? 0 : type.hashCode());
        result = 31 * result + (classifier == null ? 0 : classifier.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        String artifactId = this.getArtifactId();
        String groupId = this.getGroupId();
        String type = this.getType();
        String classifier = this.getClassifier();
        DependencyView other = (DependencyView)obj;
        String oArtifactId = other.getArtifactId();
        String oGroupId = other.getGroupId();
        String otype = other.getType();
        String oclassifier = other.getClassifier();
        if (artifactId == null ? oArtifactId != null : !artifactId.equals(oArtifactId)) {
            return false;
        }
        if (groupId == null ? oGroupId != null : !groupId.equals(oGroupId)) {
            return false;
        }
        if (classifier == null ? oclassifier != null : !classifier.equals(oclassifier)) {
            return false;
        }
        return type.equals(otype);
    }
}

