/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.filearc;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.filearc.FileTransportConfig;
import org.commonjava.maven.galley.filearc.internal.FileDownload;
import org.commonjava.maven.galley.filearc.internal.FileExistence;
import org.commonjava.maven.galley.filearc.internal.FileListing;
import org.commonjava.maven.galley.filearc.internal.FilePublish;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.spi.io.PathGenerator;
import org.commonjava.maven.galley.spi.transport.DownloadJob;
import org.commonjava.maven.galley.spi.transport.ExistenceJob;
import org.commonjava.maven.galley.spi.transport.ListingJob;
import org.commonjava.maven.galley.spi.transport.PublishJob;
import org.commonjava.maven.galley.spi.transport.Transport;
import org.commonjava.maven.galley.util.PathUtils;

@ApplicationScoped
@Named(value="file-galley-transport")
public class FileTransport
implements Transport {
    @Inject
    private FileTransportConfig config;

    public FileTransport() {
    }

    public FileTransport(File pubDir, PathGenerator generator) {
        this.config = new FileTransportConfig(pubDir, generator);
    }

    public FileTransport(FileTransportConfig config) {
        this.config = config;
    }

    public DownloadJob createDownloadJob(ConcreteResource resource, Transfer target, Map<Transfer, Long> transferSizes, int timeoutSeconds, EventMetadata eventMetadata) throws TransferException {
        File src = this.getFile(resource);
        transferSizes.put(target, src.length());
        return new FileDownload(target, src, eventMetadata);
    }

    public PublishJob createPublishJob(ConcreteResource resource, InputStream stream, long length, int timeoutSeconds) throws TransferException {
        return this.createPublishJob(resource, stream, length, null, timeoutSeconds);
    }

    public PublishJob createPublishJob(ConcreteResource resource, InputStream stream, long length, String contentType, int timeoutSeconds) throws TransferException {
        File pubDir = this.config.getPubDir();
        if (pubDir == null) {
            throw new TransferException("This transport is read-only!", new Object[0]);
        }
        File dest = new File(pubDir, this.config.getGenerator().getFilePath(resource));
        File dir = dest.getParentFile();
        if (dir != null && !dir.exists() && !dir.mkdirs()) {
            throw new TransferException("Cannot create directory: %s", new Object[]{dir});
        }
        return new FilePublish(dest, stream);
    }

    public boolean handles(Location location) {
        String uri = location.getUri();
        return uri != null && uri.startsWith("file:");
    }

    public ListingJob createListingJob(ConcreteResource resource, Transfer target, int timeoutSeconds) throws TransferException {
        File src = this.getFile(resource);
        return new FileListing(resource, src);
    }

    public ExistenceJob createExistenceJob(ConcreteResource resource, Transfer target, int timeoutSeconds) throws TransferException {
        File src = this.getFile(resource);
        return new FileExistence(src);
    }

    private File getFile(ConcreteResource resource) {
        return new File(PathUtils.normalize((String[])new String[]{resource.getLocationUri(), resource.getPath()}));
    }

    public boolean allowsCaching() {
        return true;
    }
}

