/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.inject.Alternative;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.util.SnapshotUtils;
import org.commonjava.maven.atlas.ident.version.part.SnapshotPart;
import org.commonjava.maven.galley.io.AbstractTransferDecorator;
import org.commonjava.maven.galley.io.OverriddenBooleanValue;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.transport.htcli.model.HttpLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Alternative
public class ContentsFilteringTransferDecorator
extends AbstractTransferDecorator {
    public OverriddenBooleanValue decorateExists(Transfer transfer) {
        Location loc = transfer.getLocation();
        boolean allowsSnapshots = loc.allowsSnapshots();
        boolean allowsReleases = loc.allowsReleases();
        if (loc instanceof HttpLocation && (!allowsSnapshots || !allowsReleases) && transfer.isFile()) {
            String version;
            boolean isSnapshot;
            String path = transfer.getPath();
            Pattern pattern = Pattern.compile(".*/([^/]+)/([^/]+)/(\\1-\\2[-.][^/]+)$");
            Matcher matcher = pattern.matcher(path);
            if (matcher.find() && ((isSnapshot = SnapshotUtils.isSnapshotVersion((String)(version = matcher.group(2)))) && !allowsSnapshots || !isSnapshot && !allowsReleases)) {
                return OverriddenBooleanValue.OVERRIDE_FALSE;
            }
        }
        return OverriddenBooleanValue.DEFER;
    }

    public OutputStream decorateWrite(OutputStream stream, Transfer transfer, TransferOperation op) throws IOException {
        Location loc = transfer.getLocation();
        boolean allowsSnapshots = loc.allowsSnapshots();
        boolean allowsReleases = loc.allowsReleases();
        if (loc instanceof HttpLocation && (!allowsSnapshots || !allowsReleases) && transfer.getFullPath().endsWith("maven-metadata.xml")) {
            return new MetadataFilteringOutputStream(stream, allowsSnapshots, allowsReleases, transfer);
        }
        return stream;
    }

    public String[] decorateListing(Transfer transfer, String[] listing) throws IOException {
        String[] pathElements;
        Location loc = transfer.getLocation();
        boolean allowsSnapshots = loc.allowsSnapshots();
        boolean allowsReleases = loc.allowsReleases();
        if (!(!(loc instanceof HttpLocation) || allowsSnapshots && allowsReleases || (pathElements = transfer.getPath().split("/")).length < 3)) {
            String artifactId = pathElements[pathElements.length - 2];
            String version = pathElements[pathElements.length - 1];
            boolean snapshotVersion = SnapshotUtils.isSnapshotVersion((String)version);
            if (!allowsSnapshots && snapshotVersion || !allowsReleases && !snapshotVersion) {
                ArrayList<String> result = new ArrayList<String>(listing.length);
                for (String element : listing) {
                    if (this.isArtifact(element, artifactId, version)) continue;
                    result.add(element);
                }
                return result.toArray(new String[result.size()]);
            }
        }
        return listing;
    }

    private boolean isArtifact(String element, String artifactId, String version) {
        if (element.endsWith("/")) {
            return false;
        }
        boolean isRemoteSnapshot = false;
        if (SnapshotUtils.isSnapshotVersion((String)version) && element.startsWith(artifactId + '-') && !element.startsWith(artifactId + '-' + version)) {
            SnapshotPart snapshotPart = SnapshotUtils.extractSnapshotVersionPart((String)version);
            int artIdLenght = artifactId.length() + 1 + version.length() - snapshotPart.getLiteral().length() + 1;
            isRemoteSnapshot = SnapshotUtils.isRemoteSnapshotVersionPart((String)StringUtils.substring((String)element, (int)artIdLenght, (int)(artIdLenght + 17)));
        }
        return element.startsWith(artifactId + '-' + version + '-') || element.startsWith(artifactId + '-' + version + '.') || isRemoteSnapshot;
    }

    private static class MetadataFilteringOutputStream
    extends FilterOutputStream {
        private static final String LATEST = "<latest>([^<]+)</latest>";
        private static final String RELEASE = "<release>([^<]+)</release>";
        private static final String VERSION = "<version>([^<]+)</version>";
        private static final String VERSIONS = "<versions>[\\s]*(?:(<version>([^<]+)</version>)[\\s]*)+</versions>";
        private StringBuilder buffer = new StringBuilder();
        private final boolean allowsSnapshots;
        private final boolean allowsReleases;
        private Transfer transfer;

        private MetadataFilteringOutputStream(OutputStream stream, boolean allowsSnapshots, boolean allowsReleases, Transfer transfer) {
            super(stream);
            this.allowsSnapshots = allowsSnapshots;
            this.allowsReleases = allowsReleases;
            this.transfer = transfer;
        }

        private String filterMetadata() {
            Pattern releasePattern;
            Matcher releaseMatcher;
            Logger logger;
            Pattern latestPattern;
            Matcher latestMatcher;
            Logger logger2;
            if (this.buffer.length() == 0) {
                return "";
            }
            Pattern versionsPattern = Pattern.compile(VERSIONS, 8);
            Matcher m = versionsPattern.matcher(this.buffer);
            ArrayList<String> versions = new ArrayList<String>();
            if (m.find()) {
                Pattern versionPattern = Pattern.compile(VERSION);
                Matcher versionMatcher = versionPattern.matcher(m.group());
                while (versionMatcher.find()) {
                    versions.add(versionMatcher.group(1));
                }
            }
            boolean changed = false;
            for (String version : new ArrayList(versions)) {
                boolean isSnapshot = SnapshotUtils.isSnapshotVersion((String)version);
                if ((this.allowsSnapshots || !isSnapshot) && (this.allowsReleases || isSnapshot)) continue;
                logger2 = LoggerFactory.getLogger(this.getClass());
                logger2.debug("FILTER: Removing prohibited version: {} from: {}", (Object)version, (Object)this.transfer);
                versions.remove(version);
                changed = true;
            }
            String filteredMetadata = this.buffer.toString();
            if (changed) {
                String filteredVersions = versions.size() == 0 ? "<versions></versions>" : "<versions>\n<version>" + StringUtils.join(versions, (String)"</version>\n<version>") + "</version>\n</versions>";
                filteredMetadata = filteredMetadata.replaceFirst(VERSIONS, filteredVersions);
            }
            if ((latestMatcher = (latestPattern = Pattern.compile(LATEST)).matcher(filteredMetadata)).find()) {
                String latestVersion = latestMatcher.group(1);
                boolean isSnapshot = latestVersion.endsWith("-SNAPSHOT");
                if (!this.allowsSnapshots && isSnapshot || !this.allowsReleases && !isSnapshot) {
                    logger = LoggerFactory.getLogger(this.getClass());
                    logger.debug("FILTER: Recalculating LATEST version; supplied value is prohibited: {} from: {}", (Object)latestVersion, (Object)this.transfer);
                    String newLatest = versions.size() > 0 ? "<latest>" + (String)versions.get(versions.size() - 1) + "</latest>" : "<latest></latest>";
                    filteredMetadata = filteredMetadata.replaceFirst(LATEST, newLatest);
                }
            }
            if (!this.allowsReleases && (releaseMatcher = (releasePattern = Pattern.compile(RELEASE)).matcher(filteredMetadata)).find()) {
                logger = LoggerFactory.getLogger(this.getClass());
                logger.debug("FILTER: Suppressing prohibited release fields from: {}", (Object)this.transfer);
                filteredMetadata = filteredMetadata.replaceFirst(RELEASE, "<release></release>");
            }
            if (!this.allowsSnapshots) {
                String snapshot;
                logger2 = LoggerFactory.getLogger(this.getClass());
                logger2.debug("FILTER: Suppressing prohibited snapshot fields from: {}", (Object)this.transfer);
                String snapshots = StringUtils.substringBetween((String)filteredMetadata, (String)"<snapshotVersions>", (String)"</snapshotVersions>");
                if (snapshots != null) {
                    filteredMetadata = filteredMetadata.replace(snapshots, "");
                }
                if ((snapshot = StringUtils.substringBetween((String)filteredMetadata, (String)"<snapshot>", (String)"</snapshot>")) != null) {
                    filteredMetadata = filteredMetadata.replace(snapshot, "");
                }
            }
            return filteredMetadata;
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer.append((char)b);
        }

        @Override
        public void flush() throws IOException {
            try {
                this.out.write(this.filterMetadata().getBytes());
                this.out.flush();
            }
            finally {
                this.buffer = null;
            }
        }
    }
}

