/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.TransferLocationException;
import org.commonjava.maven.galley.config.TransportMetricConfig;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.spi.transport.DownloadJob;
import org.commonjava.maven.galley.spi.transport.ExistenceJob;
import org.commonjava.maven.galley.spi.transport.ListingJob;
import org.commonjava.maven.galley.spi.transport.PublishJob;
import org.commonjava.maven.galley.spi.transport.Transport;
import org.commonjava.maven.galley.transport.htcli.Http;
import org.commonjava.maven.galley.transport.htcli.conf.GlobalHttpConfiguration;
import org.commonjava.maven.galley.transport.htcli.internal.HttpDownload;
import org.commonjava.maven.galley.transport.htcli.internal.HttpExistence;
import org.commonjava.maven.galley.transport.htcli.internal.HttpListing;
import org.commonjava.maven.galley.transport.htcli.internal.HttpPublish;
import org.commonjava.maven.galley.transport.htcli.internal.model.WrapperHttpLocation;
import org.commonjava.maven.galley.transport.htcli.model.HttpLocation;
import org.commonjava.maven.galley.util.UrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named
public class HttpClientTransport
implements Transport {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private Http http;
    @Inject
    private GlobalHttpConfiguration globalConfig;
    @Inject
    private ObjectMapper mapper;
    @Inject
    private MetricRegistry metricRegistry;
    @Inject
    private TransportMetricConfig metricConfig;

    protected HttpClientTransport() {
    }

    public HttpClientTransport(Http http) {
        this(http, new ObjectMapper(), null, null, null);
    }

    public HttpClientTransport(Http http, ObjectMapper mapper, GlobalHttpConfiguration globalConfig, MetricRegistry metricRegistry, TransportMetricConfig metricConfig) {
        this.http = http;
        this.mapper = mapper;
        this.globalConfig = globalConfig;
        this.metricRegistry = metricRegistry;
        this.metricConfig = metricConfig;
    }

    @PreDestroy
    public void shutdown() {
        try {
            this.http.close();
        }
        catch (IOException e) {
            this.logger.error("Failed to shutdown HTTP manager.", (Throwable)e);
        }
    }

    public DownloadJob createDownloadJob(ConcreteResource resource, Transfer target, Map<Transfer, Long> transferSizes, int timeoutSeconds, EventMetadata eventMetadata) throws TransferException {
        return new HttpDownload(this.getUrl(resource), this.getHttpLocation(resource.getLocation()), target, transferSizes, eventMetadata, this.http, this.mapper, this.metricRegistry, this.metricConfig);
    }

    public PublishJob createPublishJob(ConcreteResource resource, InputStream stream, long length, String contentType, int timeoutSeconds) throws TransferException {
        return new HttpPublish(this.getUrl(resource), this.getHttpLocation(resource.getLocation()), stream, length, contentType, this.http);
    }

    public PublishJob createPublishJob(ConcreteResource resource, InputStream stream, long length, int timeoutSeconds) throws TransferException {
        return this.createPublishJob(resource, stream, length, null, timeoutSeconds);
    }

    public boolean handles(Location location) {
        String uri = location.getUri();
        try {
            return uri != null && uri.startsWith("http") && new URL(location.getUri()) != null;
        }
        catch (MalformedURLException e) {
            this.logger.warn(String.format("HTTP transport cannot handle: %s. Error parsing URL: %s", location, e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public ListingJob createListingJob(ConcreteResource resource, Transfer target, int timeoutSeconds) throws TransferException {
        return new HttpListing(this.getUrl(resource), new ConcreteResource((Location)this.getHttpLocation(resource.getLocation()), new String[]{resource.getPath()}), this.http);
    }

    private HttpLocation getHttpLocation(Location repository) throws TransferException {
        try {
            return repository instanceof HttpLocation ? (HttpLocation)repository : new WrapperHttpLocation(repository, this.globalConfig);
        }
        catch (MalformedURLException e) {
            throw new TransferLocationException(repository, "Failed to parse base-URL for: {}", (Throwable)e, new Object[]{repository.getUri()});
        }
    }

    public ExistenceJob createExistenceJob(ConcreteResource resource, Transfer target, int timeoutSeconds) throws TransferException {
        return new HttpExistence(this.getUrl(resource), this.getHttpLocation(resource.getLocation()), target, this.http, this.mapper);
    }

    private String getUrl(ConcreteResource resource) throws TransferException {
        try {
            return UrlUtils.buildUrl((ConcreteResource)resource);
        }
        catch (MalformedURLException e) {
            throw new TransferLocationException(resource.getLocation(), "Failed to build URL for resource: {}. Reason: {}", (Throwable)e, new Object[]{resource, e.getMessage()});
        }
    }

    public boolean allowsCaching() {
        return true;
    }
}

