/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli.util;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public final class CertEnumerator {
    private final KeyStore ks;

    public CertEnumerator(KeyStore ks) {
        this.ks = ks;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            Enumeration<String> aliases = this.ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)this.ks.getCertificate(alias);
                if (cert == null) continue;
                sb.append("\n").append(cert.getSubjectDN());
            }
        }
        catch (KeyStoreException e) {
            sb.append("ERROR READING KEYSTORE");
        }
        return sb.toString();
    }
}

