/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.invocation;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.crsh.cli.SyntaxException;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.invocation.ArgumentMatch;
import org.crsh.cli.impl.invocation.CommandInvoker;
import org.crsh.cli.impl.invocation.InvocationException;
import org.crsh.cli.impl.invocation.OptionMatch;
import org.crsh.cli.impl.invocation.ParameterMatch;

public final class InvocationMatch<T> {
    private final CommandDescriptor<T> descriptor;
    private Map<OptionDescriptor, OptionMatch> options;
    private List<ArgumentMatch> arguments;
    private String rest;
    private final InvocationMatch<T> owner;

    public InvocationMatch(CommandDescriptor<T> descriptor) {
        this(null, descriptor);
    }

    private InvocationMatch(InvocationMatch<T> owner, CommandDescriptor<T> descriptor) {
        this.owner = owner;
        this.descriptor = descriptor;
        this.options = Collections.emptyMap();
        this.rest = null;
        this.arguments = Collections.emptyList();
    }

    public InvocationMatch<T> owner() {
        return this.owner;
    }

    public InvocationMatch<T> subordinate(String name) {
        CommandDescriptor<T> subordinate = this.descriptor.getSubordinate(name);
        if (subordinate != null) {
            return new InvocationMatch<T>(this, subordinate);
        }
        return null;
    }

    public CommandDescriptor<T> getDescriptor() {
        return this.descriptor;
    }

    public final <D extends ParameterDescriptor> ParameterMatch<D> getParameter(D parameter) {
        if (parameter instanceof OptionDescriptor) {
            return this.options.get(parameter);
        }
        for (ArgumentMatch argumentMatch : this.arguments) {
            if (argumentMatch.getParameter() != parameter) continue;
            return argumentMatch;
        }
        return null;
    }

    public CommandInvoker<T, ?> getInvoker() {
        return this.descriptor.getInvoker(this);
    }

    public Object invoke(T command) throws InvocationException, SyntaxException {
        CommandInvoker<T, ?> invoker = this.getInvoker();
        if (invoker != null) {
            return invoker.invoke(command);
        }
        return null;
    }

    public Collection<OptionMatch> options() {
        return this.options.values();
    }

    public void option(OptionMatch option) {
        if (this.options.isEmpty()) {
            this.options = new LinkedHashMap<OptionDescriptor, OptionMatch>();
        }
        this.options.put((OptionDescriptor)option.getParameter(), option);
    }

    public Collection<ArgumentMatch> arguments() {
        return this.arguments;
    }

    public void argument(ArgumentMatch argument) {
        if (this.arguments.isEmpty()) {
            this.arguments = new LinkedList<ArgumentMatch>();
        }
        this.arguments.add(argument);
    }

    public String getRest() {
        return this.rest;
    }

    public void setRest(String rest) {
        this.rest = rest;
    }
}

