/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import org.crsh.cli.SyntaxException;
import org.crsh.cli.descriptor.ArgumentDescriptor;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.Description;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.descriptor.IntrospectionException;
import org.crsh.cli.impl.invocation.CommandInvoker;
import org.crsh.cli.impl.invocation.InvocationException;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.ParameterMatch;
import org.crsh.cli.impl.lang.Binding;
import org.crsh.cli.impl.lang.ClassDescriptor;
import org.crsh.cli.impl.lang.Instance;
import org.crsh.cli.impl.lang.ObjectCommandDescriptor;
import org.crsh.cli.impl.lang.ObjectCommandInvoker;
import org.crsh.cli.impl.lang.Util;

class MethodDescriptor<T>
extends ObjectCommandDescriptor<T> {
    private final ClassDescriptor<T> owner;
    private final Method method;

    public MethodDescriptor(ClassDescriptor<T> owner, Method method, String name, Description info) throws IntrospectionException {
        super(name, info);
        this.owner = owner;
        this.method = method;
    }

    @Override
    protected void addParameter(ParameterDescriptor parameter) throws IntrospectionException, NullPointerException, IllegalArgumentException {
        super.addParameter(parameter);
    }

    @Override
    public CommandDescriptor<Instance<T>> getOwner() {
        return this.owner;
    }

    @Override
    public Map<String, ? extends CommandDescriptor<Instance<T>>> getSubordinates() {
        return Collections.emptyMap();
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public CommandInvoker<Instance<T>, ?> getInvoker(InvocationMatch<Instance<T>> match) {
        Class<?> type = this.method.getReturnType();
        return this.getInvoker2(match, type);
    }

    static void bind(InvocationMatch<?> match, Iterable<ParameterDescriptor> parameters, Object target, Object[] args) {
        for (ParameterDescriptor parameter : parameters) {
            Object value;
            ParameterMatch<ParameterDescriptor> parameterMatch = match.getParameter(parameter);
            Object object = value = parameterMatch != null ? parameterMatch.computeValue() : null;
            if (value == null) {
                if (!parameter.getDeclaredType().isPrimitive() && !parameter.isRequired()) continue;
                if (parameter instanceof ArgumentDescriptor) {
                    ArgumentDescriptor argument = (ArgumentDescriptor)parameter;
                    throw new SyntaxException("Missing argument " + argument.getName());
                }
                OptionDescriptor option = (OptionDescriptor)parameter;
                throw new SyntaxException("Missing option " + option.getNames());
            }
            ((Binding)((Object)parameter)).set(target, args, value);
        }
    }

    private <V> ObjectCommandInvoker<T, V> getInvoker2(final InvocationMatch<Instance<T>> match, final Class<V> returnType) {
        return new ObjectCommandInvoker<T, V>(match){

            @Override
            public Class<V> getReturnType() {
                return returnType;
            }

            @Override
            public Type getGenericReturnType() {
                return MethodDescriptor.this.getMethod().getGenericReturnType();
            }

            @Override
            public Class<?>[] getParameterTypes() {
                return MethodDescriptor.this.getMethod().getParameterTypes();
            }

            @Override
            public Type[] getGenericParameterTypes() {
                return MethodDescriptor.this.getMethod().getGenericParameterTypes();
            }

            @Override
            public V invoke(Instance<T> commandInstance) throws InvocationException, SyntaxException {
                Object command = null;
                try {
                    command = commandInstance.get();
                }
                catch (Exception e) {
                    throw new InvocationException(e);
                }
                if (MethodDescriptor.this.owner != null) {
                    MethodDescriptor.bind(match.owner(), MethodDescriptor.this.owner.getParameters(), command, Util.EMPTY_ARGS);
                }
                Method m = MethodDescriptor.this.getMethod();
                Class<?>[] parameterTypes = m.getParameterTypes();
                Object[] mArgs = new Object[parameterTypes.length];
                MethodDescriptor.bind(match, MethodDescriptor.this.getParameters(), command, mArgs);
                for (int i = 0; i < mArgs.length; ++i) {
                    Object v;
                    Class<?> parameterType = parameterTypes[i];
                    if (mArgs[i] == null && (v = commandInstance.resolve(parameterType)) != null) {
                        mArgs[i] = v;
                    }
                    if (mArgs[i] != null || !parameterType.isPrimitive()) continue;
                    throw new SyntaxException("Method argument at position " + i + " of " + m + " is missing");
                }
                try {
                    Object ret = m.invoke(command, mArgs);
                    return returnType.cast(ret);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    throw new InvocationException(t);
                }
                catch (IllegalAccessException t) {
                    throw new InvocationException(t);
                }
            }
        };
    }
}

