/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.sshd.ClientSession;
import org.apache.sshd.client.UserAuth;
import org.apache.sshd.client.UserInteraction;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAuthKeyboardInteractive
implements UserAuth {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ClientSession session;
    private String service;
    private Iterator<String> passwords;
    private String current;
    private int nbTrials;
    private int maxTrials;

    @Override
    public void init(ClientSession session, String service, List<Object> identities) throws Exception {
        this.session = session;
        this.service = service;
        ArrayList<String> pwds = new ArrayList<String>();
        for (Object o : identities) {
            if (!(o instanceof String)) continue;
            pwds.add((String)o);
        }
        this.passwords = pwds.iterator();
        this.maxTrials = session.getIntProperty("password-prompts", 3);
    }

    @Override
    public boolean process(Buffer buffer) throws Exception {
        if (buffer == null) {
            if (this.passwords.hasNext()) {
                this.current = this.passwords.next();
            } else if (this.nbTrials++ < this.maxTrials) {
                this.current = null;
            } else {
                return false;
            }
            this.log.debug("Send SSH_MSG_USERAUTH_REQUEST for keyboard-interactive");
            buffer = this.session.createBuffer((byte)50);
            buffer.putString(this.session.getUsername());
            buffer.putString(this.service);
            buffer.putString("keyboard-interactive");
            buffer.putString("");
            buffer.putString("");
            this.session.writePacket(buffer);
            return true;
        }
        byte cmd = buffer.getByte();
        if (cmd == 60) {
            this.log.debug("Received SSH_MSG_USERAUTH_INFO_REQUEST");
            String name = buffer.getString();
            String instruction = buffer.getString();
            String language_tag = buffer.getString();
            this.log.info("Received {} {} {}", name, instruction, language_tag);
            int num = buffer.getInt();
            Object[] prompt = new String[num];
            boolean[] echo = new boolean[num];
            for (int i = 0; i < num; ++i) {
                prompt[i] = buffer.getString();
                echo[i] = buffer.getByte() != 0;
            }
            this.log.debug("Promt: {}", prompt);
            this.log.debug("Echo: {}", (Object)echo);
            String[] rep = null;
            if (num == 0) {
                rep = new String[]{};
            } else if (num == 1 && this.current != null && !echo[0] && ((String)prompt[0]).toLowerCase().startsWith("password:")) {
                rep = new String[]{this.current};
            } else {
                UserInteraction ui = this.session.getFactoryManager().getUserInteraction();
                if (ui != null) {
                    String dest = this.session.getUsername() + "@" + ((AbstractSession)((Object)this.session)).getIoSession().getRemoteAddress().toString();
                    rep = ui.interactive(dest, name, instruction, (String[])prompt, echo);
                }
            }
            if (rep == null) {
                return false;
            }
            buffer = this.session.createBuffer((byte)61);
            buffer.putInt(rep.length);
            for (String r : rep) {
                buffer.putString(r);
            }
            this.session.writePacket(buffer);
            return true;
        }
        throw new IllegalStateException("Received unknown packet");
    }

    @Override
    public void destroy() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<UserAuth> {
        @Override
        public String getName() {
            return "keyboard-interactive";
        }

        @Override
        public UserAuth create() {
            return new UserAuthKeyboardInteractive();
        }
    }
}

