/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.deprecated;

import java.io.IOException;
import org.apache.sshd.client.UserInteraction;
import org.apache.sshd.client.auth.deprecated.AbstractUserAuth;
import org.apache.sshd.client.auth.deprecated.UserAuth;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.util.Buffer;

public class UserAuthKeyboardInteractive
extends AbstractUserAuth {
    private final String password;

    public UserAuthKeyboardInteractive(ClientSessionImpl session, String service, String password) {
        super(session, service);
        this.password = password;
    }

    public UserAuth.Result next(Buffer buffer) throws IOException {
        if (buffer == null) {
            this.log.debug("Send SSH_MSG_USERAUTH_REQUEST for password");
            buffer = this.session.createBuffer((byte)50);
            buffer.putString(this.session.getUsername());
            buffer.putString(this.service);
            buffer.putString("keyboard-interactive");
            buffer.putString("");
            buffer.putString("");
            this.session.writePacket(buffer);
            return UserAuth.Result.Continued;
        }
        byte cmd = buffer.getByte();
        switch (cmd) {
            case 60: {
                this.log.debug("Received SSH_MSG_USERAUTH_INFO_REQUEST");
                String name = buffer.getString();
                String instruction = buffer.getString();
                String language_tag = buffer.getString();
                this.log.info("Received {} {} {}", name, instruction, language_tag);
                int num = buffer.getInt();
                Object[] prompt = new String[num];
                boolean[] echo = new boolean[num];
                for (int i = 0; i < num; ++i) {
                    prompt[i] = buffer.getString();
                    echo[i] = buffer.getByte() != 0;
                }
                this.log.debug("Promt: {}", prompt);
                this.log.debug("Echo: {}", (Object)echo);
                String[] rep = null;
                if (num == 0) {
                    rep = new String[]{};
                } else if (num == 1 && this.password != null && !echo[0] && ((String)prompt[0]).toLowerCase().startsWith("password:")) {
                    rep = new String[]{this.password};
                } else {
                    UserInteraction ui = this.session.getFactoryManager().getUserInteraction();
                    if (ui != null) {
                        String dest = this.session.getUsername() + "@" + this.session.getIoSession().getRemoteAddress().toString();
                        rep = ui.interactive(dest, name, instruction, (String[])prompt, echo);
                    }
                }
                if (rep == null) {
                    return UserAuth.Result.Failure;
                }
                buffer = this.session.createBuffer((byte)61);
                buffer.putInt(rep.length);
                for (String r : rep) {
                    buffer.putString(r);
                }
                this.session.writePacket(buffer);
                return UserAuth.Result.Continued;
            }
            case 52: {
                this.log.debug("Received SSH_MSG_USERAUTH_SUCCESS");
                return UserAuth.Result.Success;
            }
            case 51: {
                this.log.debug("Received SSH_MSG_USERAUTH_FAILURE");
                return UserAuth.Result.Failure;
            }
        }
        this.log.debug("Received unknown packet {}", (Object)cmd);
        return UserAuth.Result.Continued;
    }
}

