/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.web.servlet;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.spi.Completion;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.WebPluginLifeCycle;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellFactory;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.util.Strings;
import org.crsh.web.servlet.CRaSHSession;
import org.crsh.web.servlet.Configurator;
import org.crsh.web.servlet.WSProcessContext;
import org.crsh.web.servlet.WebPlugin;

@ServerEndpoint(value="/crash", configurator=Configurator.class)
public class CRaSHConnector {
    static final Logger log = Logger.getLogger(CRaSHConnector.class.getName());
    private final ConcurrentHashMap<String, CRaSHSession> sessions = new ConcurrentHashMap();
    private static final ThreadLocal<Session> current = new ThreadLocal();

    public static String getHttpSessionId() {
        Session session = current.get();
        return (String)session.getUserProperties().get("CRASHID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnOpen
    public void start(Session wsSession) {
        current.set(wsSession);
        try {
            URI uri = wsSession.getRequestURI();
            String path = uri.getPath();
            log.fine("Establishing session for " + path);
            String contextPath = path.substring(0, path.lastIndexOf(47));
            PluginContext context = WebPluginLifeCycle.getPluginContext((String)contextPath);
            if (context != null) {
                Boolean enabled = (Boolean)context.getProperty(WebPlugin.ENABLED);
                if (enabled != null && enabled.booleanValue()) {
                    log.fine("Using shell " + context);
                    ShellFactory factory = (ShellFactory)context.getPlugin(ShellFactory.class);
                    Principal user = wsSession.getUserPrincipal();
                    Shell shell = factory.create(user);
                    CRaSHSession session = new CRaSHSession(wsSession, shell);
                    this.sessions.put(wsSession.getId(), session);
                    log.fine("Established session " + wsSession.getId());
                } else {
                    log.fine("Web plugin disabled");
                }
            } else {
                log.fine("No shell found");
            }
        }
        finally {
            current.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnClose
    public void end(Session wsSession) {
        current.set(wsSession);
        try {
            CRaSHSession session = this.sessions.remove(wsSession.getId());
            if (session != null) {
                log.fine("Destroying session " + wsSession.getId());
                WSProcessContext current = session.current.getAndSet(null);
                if (current != null) {
                    log.fine("Cancelling on going command " + current.command + " for " + wsSession.getId());
                    current.process.cancel();
                }
            } else {
                log.fine("No shell session found");
            }
        }
        finally {
            current.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnMessage
    public void incoming(String message, Session wsSession) {
        block19: {
            String key = wsSession.getId();
            log.fine("Received message " + message + " from session " + key);
            current.set(wsSession);
            try {
                CRaSHSession session = this.sessions.get(key);
                if (session != null) {
                    JsonParser parser = new JsonParser();
                    JsonElement json = parser.parse(message);
                    if (!(json instanceof JsonObject)) break block19;
                    JsonObject event = (JsonObject)json;
                    JsonElement type = event.get("type");
                    if (type.getAsString().equals("welcome")) {
                        log.fine("Sending welcome + prompt");
                        session.send("print", session.shell.getWelcome());
                        session.send("prompt", session.shell.getPrompt());
                        break block19;
                    }
                    if (type.getAsString().equals("execute")) {
                        String command = event.get("command").getAsString();
                        int width = event.get("width").getAsInt();
                        int height = event.get("height").getAsInt();
                        ShellProcess process = session.shell.createProcess(command);
                        WSProcessContext context = new WSProcessContext(session, process, command, width, height);
                        if (session.current.getAndSet(context) == null) {
                            log.fine("Executing \"" + command + "\"");
                            process.execute((ShellProcessContext)context);
                        } else {
                            log.fine("Could not execute \"" + command + "\"");
                        }
                        break block19;
                    }
                    if (type.getAsString().equals("cancel")) {
                        WSProcessContext current = session.current.getAndSet(null);
                        if (current != null) {
                            log.fine("Cancelling command \"" + current.command + "\"");
                            current.process.cancel();
                        } else {
                            log.fine("No command to cancel");
                        }
                        break block19;
                    }
                    if (!type.getAsString().equals("complete")) break block19;
                    String prefix = event.get("prefix").getAsString();
                    CompletionMatch completion = session.shell.complete(prefix);
                    Completion completions = completion.getValue();
                    Delimiter delimiter = completion.getDelimiter();
                    StringBuilder sb = new StringBuilder();
                    ArrayList<String> values = new ArrayList<String>();
                    try {
                        if (completions.getSize() == 1) {
                            String value = (String)completions.getValues().iterator().next();
                            delimiter.escape((CharSequence)value, (Appendable)sb);
                            if (completions.get(value).booleanValue()) {
                                sb.append(delimiter.getValue());
                            }
                            values.add(sb.toString());
                        } else {
                            String commonCompletion = Strings.findLongestCommonPrefix((Iterable)completions.getValues());
                            if (commonCompletion.length() > 0) {
                                delimiter.escape((CharSequence)commonCompletion, (Appendable)sb);
                                values.add(sb.toString());
                            } else {
                                for (Map.Entry entry : completions) {
                                    delimiter.escape((CharSequence)entry.getKey(), (Appendable)sb);
                                    values.add(sb.toString());
                                    sb.setLength(0);
                                }
                            }
                        }
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    log.fine("Completing \"" + prefix + "\" with " + values);
                    session.send("complete", values);
                    break block19;
                }
                log.fine("No shell session found");
            }
            finally {
                current.set(null);
            }
        }
    }
}

