/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.crsh.cli.descriptor.ArgumentDescriptor;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.impl.Multiplicity;
import org.crsh.cli.impl.parser.Event;
import org.crsh.cli.impl.parser.Mode;
import org.crsh.cli.impl.tokenizer.Token;
import org.crsh.cli.impl.tokenizer.Tokenizer;

abstract class Status {
    Status() {
    }

    abstract <T> Response<T> process(Request<T> var1);

    static class ReadingArg
    extends Status {
        private final int index;

        ReadingArg() {
            this(0);
        }

        private ReadingArg(int index) {
            this.index = index;
        }

        ReadingArg next() {
            return new ReadingArg(this.index + 1);
        }

        @Override
        <T> Response<T> process(Request<T> req) {
            Token token = req.tokenizer.peek();
            Response response = new Response();
            if (token == null) {
                response.add(new Event.Stop.Done(req.tokenizer.getIndex()));
            } else if (token instanceof Token.Whitespace) {
                response.add(new Event.Separator((Token.Whitespace)token));
                req.tokenizer.next();
            } else {
                Token.Literal literal = (Token.Literal)token;
                List<ArgumentDescriptor> arguments = req.command.getArguments();
                if (this.index < arguments.size()) {
                    ArgumentDescriptor argument = arguments.get(this.index);
                    switch (argument.getMultiplicity()) {
                        case SINGLE: {
                            req.tokenizer.next();
                            response.add(new Event.Argument(req.command, argument, Arrays.asList(literal)));
                            response.status = this.next();
                            break;
                        }
                        case MULTI: {
                            req.tokenizer.next();
                            ArrayList<Token.Literal> values = new ArrayList<Token.Literal>();
                            values.add(literal);
                            while (req.tokenizer.hasNext()) {
                                Token capture = req.tokenizer.next();
                                if (capture instanceof Token.Literal) {
                                    values.add((Token.Literal)capture);
                                    continue;
                                }
                                if (req.tokenizer.hasNext()) continue;
                                req.tokenizer.pushBack();
                                break;
                            }
                            response.add(new Event.Argument((CommandDescriptor<?>)req.command, argument, (List<Token.Literal>)values));
                        }
                    }
                } else {
                    response.add(new Event.Stop.Unresolved.TooManyArguments(literal));
                }
            }
            return response;
        }
    }

    static class Done
    extends Status {
        Done() {
        }

        @Override
        <T> Response<T> process(Request<T> req) {
            throw new IllegalStateException();
        }
    }

    static class ComputeArg
    extends Status {
        ComputeArg() {
        }

        @Override
        <T> Response<T> process(Request<T> req) {
            Token token = req.tokenizer.peek();
            Response response = new Response();
            if (token == null) {
                response.add(new Event.Stop.Done(req.tokenizer.getIndex()));
            } else if (token instanceof Token.Whitespace) {
                response.add(new Event.Separator((Token.Whitespace)token));
                req.tokenizer.next();
            } else {
                List<ArgumentDescriptor> arguments = req.command.getArguments();
                int tokenCount = 0;
                int wordCount = 0;
                do {
                    Token t;
                    if ((t = req.tokenizer.next()) instanceof Token.Literal) {
                        ++wordCount;
                    }
                    ++tokenCount;
                } while (req.tokenizer.hasNext());
                req.tokenizer.pushBack(tokenCount);
                int oneCount = 0;
                int zeroOrOneCount = 0;
                int index = 0;
                for (ArgumentDescriptor argument : arguments) {
                    Multiplicity multiplicity = argument.getMultiplicity();
                    if (multiplicity == Multiplicity.SINGLE) {
                        if (argument.isRequired()) {
                            if (oneCount + 1 > wordCount) break;
                            ++oneCount;
                        } else {
                            ++zeroOrOneCount;
                        }
                    }
                    ++index;
                }
                arguments = arguments.subList(0, index);
                int toConsume = wordCount - oneCount;
                zeroOrOneCount = Math.min(zeroOrOneCount, toConsume);
                toConsume -= zeroOrOneCount;
                LinkedList<Event> events = new LinkedList<Event>();
                for (ArgumentDescriptor argument : arguments) {
                    int size;
                    switch (argument.getMultiplicity()) {
                        case SINGLE: {
                            if (argument.isRequired()) {
                                size = 1;
                                break;
                            }
                            if (zeroOrOneCount > 0) {
                                --zeroOrOneCount;
                                size = 1;
                                break;
                            }
                            size = 0;
                            break;
                        }
                        case MULTI: {
                            size = toConsume;
                            toConsume = 0;
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    if (size <= 0) continue;
                    ArrayList<Token.Literal> values = new ArrayList<Token.Literal>(size);
                    while (size > 0) {
                        Token t = req.tokenizer.next();
                        if (!(t instanceof Token.Literal)) continue;
                        values.add((Token.Literal)t);
                        --size;
                    }
                    events.addLast(new Event.Argument((CommandDescriptor<?>)req.command, argument, (List<Token.Literal>)values));
                    if (!req.tokenizer.hasNext() || !(req.tokenizer.peek() instanceof Token.Whitespace)) continue;
                    events.addLast(new Event.Separator((Token.Whitespace)req.tokenizer.next()));
                }
                events.addLast(new Event.Stop.Done(req.tokenizer.getIndex()));
                response.status = new Done();
                response.addAll(events);
            }
            return response;
        }
    }

    static class WantReadArg
    extends Status {
        WantReadArg() {
        }

        @Override
        <T> Response<T> process(Request<T> req) {
            switch (req.mode) {
                case INVOKE: {
                    return new Response(new ComputeArg());
                }
                case COMPLETE: {
                    return new Response(new ReadingArg());
                }
            }
            throw new AssertionError();
        }
    }

    static class ReadingOption
    extends Status {
        ReadingOption() {
        }

        @Override
        <T> Response<T> process(Request<T> req) {
            Response response = new Response();
            Token token = req.tokenizer.peek();
            if (token == null) {
                response.add(new Event.Stop.Done(req.tokenizer.getIndex()));
            } else if (token instanceof Token.Whitespace) {
                response.add(new Event.Separator((Token.Whitespace)token));
                req.tokenizer.next();
            } else {
                Token.Literal literal = (Token.Literal)token;
                if (literal instanceof Token.Literal.Option) {
                    Token.Literal.Option optionToken = (Token.Literal.Option)literal;
                    if (optionToken.getName().length() == 0 && optionToken instanceof Token.Literal.Option.Long) {
                        req.tokenizer.next();
                        if (req.tokenizer.hasNext()) {
                            CommandDescriptor m = req.command.getSubordinate(req.mainName);
                            if (m != null) {
                                response.command = m;
                                response.add(new Event.Subordinate.Implicit(m, optionToken));
                            }
                            response.status = new WantReadArg();
                        } else if (req.mode == Mode.INVOKE) {
                            CommandDescriptor m = req.command.getSubordinate(req.mainName);
                            if (m != null) {
                                response.command = m;
                                response.add(new Event.Subordinate.Implicit(m, optionToken));
                            }
                            response.status = new Done();
                            response.add(new Event.Stop.Done(req.tokenizer.getIndex()));
                        } else {
                            CommandDescriptor m = req.command.getSubordinate(req.mainName);
                            if (m != null) {
                                response.command = m;
                                response.add(new Event.Subordinate.Implicit(m, optionToken));
                                response.add(new Event.Stop.Unresolved.NoSuchOption(optionToken));
                            } else {
                                response.add(new Event.Stop.Unresolved.NoSuchOption(optionToken));
                            }
                        }
                    } else {
                        OptionDescriptor desc = req.command.findOption(literal.getValue());
                        if (desc != null) {
                            req.tokenizer.next();
                            int arity = desc.getArity();
                            LinkedList<Token.Literal.Word> values = new LinkedList<Token.Literal.Word>();
                            while (arity > 0 && req.tokenizer.hasNext()) {
                                Token a = req.tokenizer.peek();
                                if (a instanceof Token.Whitespace) {
                                    req.tokenizer.next();
                                    if (req.tokenizer.hasNext() && req.tokenizer.peek() instanceof Token.Literal.Word) continue;
                                    req.tokenizer.pushBack();
                                    break;
                                }
                                Token.Literal b = (Token.Literal)a;
                                if (b instanceof Token.Literal.Word) {
                                    values.addLast((Token.Literal.Word)b);
                                    req.tokenizer.next();
                                    --arity;
                                    continue;
                                }
                                req.tokenizer.pushBack();
                                break;
                            }
                            response.add(new Event.Option(req.command, desc, optionToken, values));
                        } else {
                            CommandDescriptor m = req.command.getSubordinate(req.mainName);
                            if (m != null) {
                                desc = m.findOption(literal.getValue());
                                if (desc != null) {
                                    response.command = m;
                                    response.add(new Event.Subordinate.Implicit(m, literal));
                                } else if (req.command.getOptionNames().size() == 0) {
                                    response.command = m;
                                    response.add(new Event.Subordinate.Implicit(m, literal));
                                } else {
                                    response.add(new Event.Stop.Unresolved.NoSuchOption(optionToken));
                                }
                            } else {
                                response.add(new Event.Stop.Unresolved.NoSuchOption(optionToken));
                            }
                        }
                    }
                } else {
                    Token.Literal.Word wordLiteral = (Token.Literal.Word)literal;
                    CommandDescriptor m = req.command.getSubordinate(wordLiteral.getValue());
                    if (m != null && !m.getName().equals(req.mainName)) {
                        response.command = m;
                        req.tokenizer.next();
                        response.add(new Event.Subordinate.Explicit(m, wordLiteral));
                    } else {
                        m = req.command.getSubordinate(req.mainName);
                        if (m != null) {
                            response.add(new Event.Subordinate.Implicit(m, wordLiteral));
                            response.status = new WantReadArg();
                            response.command = m;
                        } else {
                            response.status = new WantReadArg();
                        }
                    }
                }
            }
            return response;
        }
    }

    static class Response<T> {
        Status status;
        LinkedList<Event> events;
        CommandDescriptor<T> command;

        Response(Status status) {
            this.status = status;
            this.events = null;
            this.command = null;
        }

        Response() {
            this.status = null;
            this.events = null;
            this.command = null;
        }

        void add(Event event) {
            if (this.events == null) {
                this.events = new LinkedList();
            }
            this.events.add(event);
        }

        void addAll(Collection<Event> toAdd) {
            if (this.events == null) {
                this.events = new LinkedList();
            }
            this.events.addAll(toAdd);
        }
    }

    static class Request<T> {
        final Mode mode;
        final String mainName;
        Tokenizer tokenizer;
        final CommandDescriptor<T> command;

        Request(Mode mode, String mainName, Tokenizer tokenizer, CommandDescriptor<T> command) {
            this.mode = mode;
            this.mainName = mainName;
            this.tokenizer = tokenizer;
            this.command = command;
        }
    }
}

