/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.matcher;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.crsh.cli.Argument;
import org.crsh.cli.Option;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.invocation.InvocationMatcher;
import org.crsh.cli.impl.lang.CommandFactory;

public class EscapeTestCase
extends TestCase {
    public void testOption() throws Exception {
        class A
        implements Runnable {
            @Option(names={"o"})
            String s;

            A() {
            }

            public void run() {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        InvocationMatcher analyzer = desc.invoker("main");
        A a = new A();
        analyzer.match("-o \" \"").invoke((Object)a);
        EscapeTestCase.assertEquals((String)" ", (String)a.s);
        a = new A();
        analyzer.match("-o \"'\"").invoke((Object)a);
        EscapeTestCase.assertEquals((String)"'", (String)a.s);
        a = new A();
        analyzer.match("-o \" a b").invoke((Object)a);
        EscapeTestCase.assertEquals((String)" a b", (String)a.s);
    }

    public void testArgumentList() throws Exception {
        class A
        implements Runnable {
            @Argument
            List<String> s;

            A() {
            }

            public void run() {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        InvocationMatcher analyzer = desc.invoker();
        A a = new A();
        analyzer.match("\" \" b").invoke((Object)a);
        EscapeTestCase.assertEquals(Arrays.asList(" ", "b"), a.s);
        a = new A();
        analyzer.match("\"'\" b").invoke((Object)a);
        EscapeTestCase.assertEquals(Arrays.asList("'", "b"), a.s);
        a = new A();
        analyzer.match("\"a b\" c").invoke((Object)a);
        EscapeTestCase.assertEquals(Arrays.asList("a b", "c"), a.s);
    }
}

