/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.descriptor;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.crsh.cli.SyntaxException;
import org.crsh.cli.descriptor.Description;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.Multiplicity;
import org.crsh.cli.impl.ParameterType;
import org.crsh.cli.impl.descriptor.IllegalParameterException;
import org.crsh.cli.impl.descriptor.IllegalValueTypeException;
import org.crsh.cli.spi.Completer;
import org.crsh.cli.type.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionDescriptor
extends ParameterDescriptor {
    private static final BitSet A = new BitSet(256);
    private static final BitSet B = new BitSet(256);
    private final int arity;
    private final List<String> names;

    private static void checkChar(String s, int index, BitSet authorized) throws IllegalParameterException {
        if (!authorized.get(s.charAt(index))) {
            throw new IllegalParameterException("Option name " + s + " cannot contain " + s.charAt(index) + " at position " + index);
        }
    }

    public OptionDescriptor(Object binding, ParameterType<?> type, List<String> names, Description info, boolean required, boolean password, boolean unquote, Class<? extends Completer> completerType, Annotation annotation) throws IllegalValueTypeException, IllegalParameterException {
        super(binding, type, info, required, password, unquote, completerType, annotation);
        if (this.getMultiplicity() == Multiplicity.MULTI && this.getType() == ValueType.BOOLEAN) {
            throw new IllegalParameterException();
        }
        names = new ArrayList<String>(names);
        for (String name : names) {
            if (name == null) {
                throw new IllegalParameterException("Option name must not be null");
            }
            int length = name.length();
            if (length == 0) {
                throw new IllegalParameterException("Option name cannot be empty");
            }
            if (!A.get(name.charAt(0))) {
                throw new IllegalParameterException("Option name " + name + " cannot start with " + name.charAt(0));
            }
            OptionDescriptor.checkChar(name, 0, A);
            OptionDescriptor.checkChar(name, length - 1, A);
            for (int i = 1; i < length - 1; ++i) {
                OptionDescriptor.checkChar(name, i, B);
            }
        }
        this.arity = this.getType() == ValueType.BOOLEAN ? 0 : 1;
        this.names = Collections.unmodifiableList(names);
    }

    public int getArity() {
        return this.arity;
    }

    public List<String> getNames() {
        return this.names;
    }

    @Override
    public Object parse(List<String> values) throws SyntaxException {
        if (this.arity == 0) {
            if (values.size() > 0) {
                throw new SyntaxException("Too many values " + values + " for option " + this.names.get(0));
            }
            return Boolean.TRUE;
        }
        if (this.getMultiplicity() == Multiplicity.SINGLE) {
            if (values.size() > 1) {
                throw new SyntaxException("Too many values " + values + " for option " + this.names.get(0));
            }
            if (values.size() == 0) {
                throw new SyntaxException("Missing option " + this.names.get(0) + " value");
            }
            String value = values.get(0);
            try {
                return this.parse(value);
            }
            catch (Exception e) {
                throw new SyntaxException("Could not parse value <" + value + "> for option " + this.names.get(0));
            }
        }
        ArrayList<Object> v = new ArrayList<Object>(values.size());
        for (String value : values) {
            try {
                v.add(this.parse(value));
            }
            catch (Exception e) {
                throw new SyntaxException("Could not parse value <" + value + "> for option " + this.names.get(0));
            }
        }
        return v;
    }

    @Override
    public void printUsage(Appendable writer) throws IOException {
        writer.append("[");
        boolean a = false;
        for (String optionName : this.names) {
            if (a) {
                writer.append(" | ");
            }
            writer.append(optionName.length() == 1 ? "-" : "--").append(optionName);
            a = true;
        }
        writer.append("]");
    }

    public String toString() {
        return "OptionDescriptor[" + this.names + "]";
    }

    static {
        for (int c = 97; c <= 122; c = (int)((char)(c + 1))) {
            A.set(c);
        }
        B.or(A);
        B.set(45);
    }
}

