/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.matcher;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import org.crsh.cli.Argument;
import org.crsh.cli.CLIException;
import org.crsh.cli.Command;
import org.crsh.cli.Option;
import org.crsh.cli.Required;
import org.crsh.cli.SyntaxException;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.InvocationMatcher;
import org.crsh.cli.impl.invocation.Resolver;
import org.crsh.cli.impl.lang.CommandFactory;
import org.crsh.cli.impl.matcher.Custom;

public class MatcherTestCase
extends TestCase {
    public void testRequiredClassOption() throws Exception {
        class A
        implements Runnable {
            @Option(names={"o"})
            @Required
            String s;

            A() {
            }

            @Override
            public void run() {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        InvocationMatcher analyzer = desc.invoker();
        A a = new A();
        analyzer.match("-o foo").invoke((Object)a);
        MatcherTestCase.assertEquals((String)"foo", (String)a.s);
        try {
            a = new A();
            analyzer.match("").invoke((Object)a);
            MatcherTestCase.fail();
        }
        catch (SyntaxException e) {
            // empty catch block
        }
    }

    public void testOptionalClassOption() throws Exception {
        class A
        implements Runnable {
            @Option(names={"o"})
            String s;

            A() {
            }

            @Override
            public void run() {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        InvocationMatcher analyzer = desc.invoker();
        A a = new A();
        analyzer.match("-o foo").invoke((Object)a);
        MatcherTestCase.assertEquals((String)"foo", (String)a.s);
        a = new A();
        analyzer.match("").invoke((Object)a);
        MatcherTestCase.assertEquals(null, (String)a.s);
    }

    public void testPrimitiveClassArgument() throws Exception {
        class A
        implements Runnable {
            @Argument
            int i;

            A() {
            }

            @Override
            public void run() {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        InvocationMatcher analyzer = desc.invoker();
        A a = new A();
        analyzer.match("5").invoke((Object)a);
        MatcherTestCase.assertEquals((int)5, (int)a.i);
        a = new A();
        analyzer.match("5 6").invoke((Object)a);
        MatcherTestCase.assertEquals((int)5, (int)a.i);
        a = new A();
        a.i = -3;
        analyzer.match("").invoke((Object)a);
        MatcherTestCase.assertEquals((int)-3, (int)a.i);
    }

    public void testPrimitiveMethodArgument() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(PMA.class);
        InvocationMatcher analyzer = desc.invoker();
        PMA a = new PMA();
        analyzer.match("m 5").invoke((Object)a);
        MatcherTestCase.assertEquals((int)5, (int)a.i);
        a = new PMA();
        analyzer.match("m 5 6").invoke((Object)a);
        MatcherTestCase.assertEquals((int)5, (int)a.i);
        a = new PMA();
        try {
            analyzer.match("m").invoke((Object)a);
            MatcherTestCase.fail();
        }
        catch (SyntaxException e) {
            // empty catch block
        }
    }

    public void testOptionalClassArgument() throws Exception {
        class A
        implements Runnable {
            @Argument
            String s;

            A() {
            }

            @Override
            public void run() {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        InvocationMatcher analyzer = desc.invoker();
        A a = new A();
        analyzer.match("foo").invoke((Object)a);
        MatcherTestCase.assertEquals((String)"foo", (String)a.s);
        a = new A();
        analyzer.match("foo bar").invoke((Object)a);
        MatcherTestCase.assertEquals((String)"foo", (String)a.s);
        a = new A();
        analyzer.match("").invoke((Object)a);
        MatcherTestCase.assertEquals(null, (String)a.s);
    }

    public void testOptionalArgumentList() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(BC.class);
        InvocationMatcher analyzer = desc.invoker();
        for (String s : Arrays.asList("", "bar ")) {
            BC a = new BC();
            analyzer.match(s + "").invoke((Object)a);
            MatcherTestCase.assertEquals(null, a.s);
            a = new BC();
            analyzer.match(s + "foo").invoke((Object)a);
            MatcherTestCase.assertEquals(Arrays.asList("foo"), a.s);
            a = new BC();
            analyzer.match(s + "foo bar").invoke((Object)a);
            MatcherTestCase.assertEquals(Arrays.asList("foo", "bar"), a.s);
            a = new BC();
            analyzer.match(s + "foo ").invoke((Object)a);
            MatcherTestCase.assertEquals(Arrays.asList("foo"), a.s);
        }
    }

    public void testOptionSyntaxException() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(OptionSyntaxException.class);
        InvocationMatcher analyzer = desc.invoker("main");
        OptionSyntaxException cmd = new OptionSyntaxException();
        try {
            analyzer.match("-o").invoke((Object)cmd);
            MatcherTestCase.fail();
        }
        catch (SyntaxException ignore) {
            // empty catch block
        }
        try {
            analyzer.match("-o 0 -o 1").invoke((Object)cmd);
            MatcherTestCase.fail();
        }
        catch (SyntaxException ignore) {
            // empty catch block
        }
        try {
            analyzer.match("-o a").invoke((Object)cmd);
            MatcherTestCase.fail();
        }
        catch (SyntaxException ignore) {
            // empty catch block
        }
        analyzer.match("-o 45").invoke((Object)cmd);
        MatcherTestCase.assertEquals((int)45, (int)cmd.option);
    }

    public void testRequiredArgumentList() throws Exception {
        class A
        implements Runnable {
            @Argument
            @Required
            List<String> s;

            A() {
            }

            @Override
            public void run() {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        InvocationMatcher analyzer = desc.invoker();
        A a = new A();
        try {
            analyzer.match("").invoke((Object)a);
            MatcherTestCase.fail();
        }
        catch (SyntaxException expected) {
            // empty catch block
        }
        a = new A();
        analyzer.match("foo").invoke((Object)a);
        MatcherTestCase.assertEquals(Arrays.asList("foo"), a.s);
        a = new A();
        analyzer.match("foo bar").invoke((Object)a);
        MatcherTestCase.assertEquals(Arrays.asList("foo", "bar"), a.s);
    }

    public void testMethodInvocation() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        InvocationMatcher analyzer = desc.invoker();
        A a = new A();
        analyzer.match("-s foo m -o bar juu").invoke((Object)a);
        MatcherTestCase.assertEquals((String)"foo", (String)a.s);
        MatcherTestCase.assertEquals((String)"bar", (String)a.o);
        MatcherTestCase.assertEquals((String)"juu", (String)a.a);
        a = new A();
        analyzer.match("m -o bar juu").invoke((Object)a);
        MatcherTestCase.assertEquals(null, (String)a.s);
        MatcherTestCase.assertEquals((String)"bar", (String)a.o);
        MatcherTestCase.assertEquals((String)"juu", (String)a.a);
        a = new A();
        analyzer.match("m juu").invoke((Object)a);
        MatcherTestCase.assertEquals(null, (String)a.s);
        MatcherTestCase.assertEquals(null, (String)a.o);
        MatcherTestCase.assertEquals((String)"juu", (String)a.a);
        a = new A();
        analyzer.match("m -o bar").invoke((Object)a);
        MatcherTestCase.assertEquals(null, (String)a.s);
        MatcherTestCase.assertEquals((String)"bar", (String)a.o);
        MatcherTestCase.assertEquals(null, (String)a.a);
        a = new A();
        analyzer.match("m").invoke((Object)a);
        MatcherTestCase.assertEquals(null, (String)a.s);
        MatcherTestCase.assertEquals(null, (String)a.o);
        MatcherTestCase.assertEquals(null, (String)a.a);
    }

    public void testMainMethodInvocation() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(B.class);
        InvocationMatcher analyzer = desc.invoker("main");
        B b = new B();
        analyzer.match("").invoke((Object)b);
        MatcherTestCase.assertEquals((int)1, (int)b.count);
    }

    public void testInvocationAttributeInjection() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(C.class);
        InvocationMatcher analyzer = desc.invoker("main");
        C c = new C();
        Resolver context = new Resolver(){

            public <T> T resolve(Class<T> type) {
                if (type.equals(Locale.class)) {
                    return type.cast(Locale.FRENCH);
                }
                return null;
            }
        };
        analyzer.match("").invoke(context, (Object)c);
        MatcherTestCase.assertEquals((Object)Locale.FRENCH, (Object)c.locale);
    }

    public void testInvocationTypeConversionInjection() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(D.class);
        D d = new D();
        desc.invoker("a").match("-o 5").invoke((Object)d);
        MatcherTestCase.assertEquals((Object)5, (Object)d.i);
        d = new D();
        desc.invoker("b").match("-o 5").invoke((Object)d);
        MatcherTestCase.assertEquals((Object)5, (Object)d.i);
    }

    public void testQuoted() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(E.class);
        E e = new E();
        desc.invoker("a").match("-o a").invoke((Object)e);
        MatcherTestCase.assertEquals((String)"a", (String)e.i);
        e = new E();
        desc.invoker("a").match("-o \"a\"").invoke((Object)e);
        MatcherTestCase.assertEquals((String)"\"a\"", (String)e.i);
    }

    public void testOptionList() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(F.class);
        F f = new F();
        desc.invoker("foo").match("-o a").invoke((Object)f);
        MatcherTestCase.assertEquals(Arrays.asList("a"), f.s);
        f = new F();
        desc.invoker("foo").match("-o a -o b").invoke((Object)f);
        MatcherTestCase.assertEquals(Arrays.asList("a", "b"), f.s);
    }

    public void testValue() throws Exception {
        CommandDescriptorImpl desc = new CommandFactory(MatcherTestCase.class.getClassLoader()).create(G.class);
        G g = new G();
        desc.invoker("foo").match("-o a").invoke((Object)g);
        MatcherTestCase.assertEquals((Object)new Custom("a"), (Object)g.o);
    }

    public void testException() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(H.class);
        H h = new H();
        InvocationMatch match = desc.invoker("foo").match("");
        try {
            match.invoke((Object)h);
            MatcherTestCase.fail();
        }
        catch (CLIException e) {
            MatcherTestCase.assertEquals(Exception.class, e.getCause().getClass());
            MatcherTestCase.assertEquals((String)"fooexception", (String)e.getCause().getMessage());
        }
    }

    public void testRuntimeException() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(I.class);
        I i = new I();
        InvocationMatch match = desc.invoker("foo").match("");
        try {
            match.invoke((Object)i);
            MatcherTestCase.fail();
        }
        catch (CLIException e) {
            MatcherTestCase.assertEquals(RuntimeException.class, e.getCause().getClass());
            MatcherTestCase.assertEquals((String)"fooruntimeexception", (String)e.getCause().getMessage());
        }
    }

    public void testError() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(J.class);
        J j = new J();
        InvocationMatch match = desc.invoker("foo").match("");
        try {
            match.invoke((Object)j);
            MatcherTestCase.fail();
        }
        catch (Error e) {
            MatcherTestCase.assertEquals((String)"fooerror", (String)e.getMessage());
        }
    }

    public void testSpecifyClassOptionBeforeSubordinate() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(K.class);
        K k = new K();
        desc.invoker("main").match("-o foo cmd").invoke((Object)k);
        MatcherTestCase.assertEquals((String)"foo", (String)k.opt);
    }

    public void testSpecifyClassOptionAfterSubordinate() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(K.class);
        K k = new K();
        desc.invoker("main").match("cmd -o foo").invoke((Object)k);
        MatcherTestCase.assertEquals(null, (String)k.opt);
    }

    public void testSpecifySubordinateOptionBeforeSubordinate() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(L.class);
        L l = new L();
        desc.invoker("main").match("-o foo cmd").invoke((Object)l);
        MatcherTestCase.assertEquals(null, (String)l.opt);
    }

    public void testSpecifySubordinateOptionAfterSubordinate() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(L.class);
        L l = new L();
        desc.invoker("main").match("cmd -o foo").invoke((Object)l);
        MatcherTestCase.assertEquals((String)"foo", (String)l.opt);
    }

    public void testImplicitSubordinateOption() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(M.class);
        M m = new M();
        desc.invoker("main").match("-o foo").invoke((Object)m);
        MatcherTestCase.assertEquals((String)"foo", (String)m.opt);
    }

    public void testBooleanParameter() throws Exception {
        class A
        implements Runnable {
            @Option(names={"o"})
            boolean o;

            A() {
            }

            @Override
            public void run() {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        InvocationMatcher analyzer = desc.invoker();
        A a = new A();
        analyzer.match("-o").invoke((Object)a);
        MatcherTestCase.assertEquals((boolean)true, (boolean)a.o);
    }

    public void testSCP() throws Exception {
        class SCP
        implements Runnable {
            @Option(names={"t"})
            boolean t;
            @Argument
            @Required
            String target;

            SCP() {
            }

            @Override
            public void run() {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(SCP.class);
        InvocationMatcher analyzer = desc.invoker();
        SCP scp = new SCP();
        InvocationMatch matcher = analyzer.match("-t -- portal:collaboration:/Documents");
        matcher.invoke((Object)scp);
        MatcherTestCase.assertEquals((boolean)true, (boolean)scp.t);
        MatcherTestCase.assertEquals((String)"portal:collaboration:/Documents", (String)scp.target);
        scp = new SCP();
        matcher = analyzer.match("-t");
        try {
            matcher.invoke((Object)scp);
            MatcherTestCase.fail();
        }
        catch (CLIException e) {
            // empty catch block
        }
    }

    public static class M {
        String opt;

        @Command
        public void main(@Option(names={"o"}) String opt) {
            this.opt = opt;
        }
    }

    public static class L {
        String opt;

        @Command
        public void cmd(@Option(names={"o"}) String opt) {
            this.opt = opt;
        }
    }

    public static class K {
        @Option(names={"o"})
        String opt;

        @Command
        public void cmd() {
        }
    }

    public static class J {
        @Command
        public void foo() {
            throw new Error("fooerror");
        }
    }

    public static class I {
        @Command
        public void foo() {
            throw new RuntimeException("fooruntimeexception");
        }
    }

    public static class H {
        @Command
        public void foo() throws Exception {
            throw new Exception("fooexception");
        }
    }

    public static class G {
        Custom o;

        @Command
        public void foo(@Option(names={"o"}) Custom o) {
            this.o = o;
        }
    }

    public static class F {
        List<String> s;

        @Command
        public void foo(@Option(names={"o"}) List<String> s) {
            this.s = s;
        }
    }

    public static class E {
        private String i;

        @Command
        public void a(@Option(names={"o"}, unquote=false) String i) {
            this.i = i;
        }
    }

    public static class D {
        private Integer i;

        @Command
        public void a(@Option(names={"o"}) Integer i) {
            this.i = i;
        }

        @Command
        public void b(@Option(names={"o"}) int i) {
            this.i = i;
        }
    }

    public static class C {
        Locale locale;

        @Command
        public void main(Locale locale) {
            this.locale = locale;
        }
    }

    public static class B {
        int count;

        @Command
        public void main() {
            ++this.count;
        }
    }

    public static class A
    implements Runnable {
        @Option(names={"s"})
        String s;
        String o;
        String a;

        @Command
        public void m(@Option(names={"o"}) String o, @Argument String a) {
            this.o = o;
            this.a = a;
        }

        @Override
        public void run() {
        }
    }

    public class OptionSyntaxException {
        @Option(names={"o"})
        int option;

        @Command
        public void main() {
        }
    }

    public static class BC
    implements Runnable {
        @Argument
        List<String> s;

        @Command
        public void bar(@Argument List<String> s) {
            this.s = s;
        }

        @Override
        public void run() {
        }
    }

    public static class PMA {
        int i;

        @Command
        public void m(@Argument int i) {
            this.i = i;
        }
    }
}

