/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.crsh.cmdline.ArgumentDescriptor;
import org.crsh.cmdline.Description;
import org.crsh.cmdline.IntrospectionException;
import org.crsh.cmdline.Multiplicity;
import org.crsh.cmdline.OptionDescriptor;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.binding.TypeBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandDescriptor<T, B extends TypeBinding> {
    private final String name;
    private final Description description;
    private final Map<String, OptionDescriptor<B>> optionMap;
    private final Set<String> shortOptionNames;
    private final Set<String> longOptionNames;
    private boolean listArgument;
    private final List<OptionDescriptor<B>> options;
    private final List<ArgumentDescriptor<B>> arguments;
    private final List<ParameterDescriptor<B>> parameters;
    private final Map<String, OptionDescriptor<B>> uOptionMap;
    private final Set<String> uShortOptionNames;
    private final Set<String> uLongOptionNames;
    private final List<OptionDescriptor<B>> uOptions;
    private final List<ArgumentDescriptor<B>> uArguments;
    private final List<ParameterDescriptor<B>> uParameters;

    CommandDescriptor(String name, Description description) throws IntrospectionException {
        this.description = description;
        this.optionMap = new LinkedHashMap<String, OptionDescriptor<B>>();
        this.arguments = new ArrayList<ArgumentDescriptor<B>>();
        this.options = new ArrayList<OptionDescriptor<B>>();
        this.name = name;
        this.parameters = new ArrayList<ParameterDescriptor<B>>();
        this.listArgument = false;
        this.shortOptionNames = new HashSet<String>();
        this.longOptionNames = new HashSet<String>();
        this.uOptionMap = Collections.unmodifiableMap(this.optionMap);
        this.uParameters = Collections.unmodifiableList(this.parameters);
        this.uOptions = Collections.unmodifiableList(this.options);
        this.uArguments = Collections.unmodifiableList(this.arguments);
        this.uShortOptionNames = this.shortOptionNames;
        this.uLongOptionNames = this.longOptionNames;
    }

    void addParameter(ParameterDescriptor<B> parameter) throws IntrospectionException, NullPointerException, IllegalArgumentException {
        if (parameter == null) {
            throw new NullPointerException("No null parameter accepted");
        }
        if (parameter.owner != null) {
            throw new IllegalArgumentException("The parameter is already associated with a command");
        }
        if (parameter instanceof OptionDescriptor) {
            OptionDescriptor option = (OptionDescriptor)parameter;
            for (String optionName : option.getNames()) {
                String name;
                if (optionName.length() == 1) {
                    name = "-" + optionName;
                    this.shortOptionNames.add(name);
                } else {
                    name = "--" + optionName;
                    this.longOptionNames.add(name);
                }
                this.optionMap.put(name, option);
            }
            this.options.add(option);
            ListIterator<ParameterDescriptor<B>> i = this.parameters.listIterator();
            while (i.hasNext()) {
                ParameterDescriptor<B> next = i.next();
                if (!(next instanceof ArgumentDescriptor)) continue;
                i.previous();
                break;
            }
            i.add(parameter);
            parameter.owner = this;
        } else if (parameter instanceof ArgumentDescriptor) {
            ArgumentDescriptor argument = (ArgumentDescriptor)parameter;
            if (argument.getMultiplicity() == Multiplicity.ZERO_OR_MORE) {
                if (this.listArgument) {
                    throw new IntrospectionException();
                }
                this.listArgument = true;
            }
            this.arguments.add(argument);
            this.parameters.add(argument);
            parameter.owner = this;
        }
    }

    public abstract Class<T> getType();

    public abstract void printUsage(Appendable var1) throws IOException;

    public abstract void printMan(Appendable var1) throws IOException;

    public abstract Map<String, ? extends CommandDescriptor<T, ?>> getSubordinates();

    public final Collection<ParameterDescriptor<B>> getParameters() {
        return this.uParameters;
    }

    public final Set<String> getOptionNames() {
        return this.uOptionMap.keySet();
    }

    public final Set<String> getShortOptionNames() {
        return this.uShortOptionNames;
    }

    public final Set<String> getLongOptionNames() {
        return this.uLongOptionNames;
    }

    public final Collection<OptionDescriptor<B>> getOptions() {
        return this.uOptions;
    }

    public final OptionDescriptor<B> getOption(String name) {
        return this.optionMap.get(name);
    }

    public abstract OptionDescriptor<?> findOption(String var1);

    public final List<ArgumentDescriptor<B>> getArguments() {
        return this.uArguments;
    }

    public final ArgumentDescriptor<B> getArgument(int index) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index >= this.arguments.size()) {
            throw new IllegalArgumentException();
        }
        return this.arguments.get(index);
    }

    public final String getName() {
        return this.name;
    }

    public final Description getDescription() {
        return this.description;
    }

    public final String getUsage() {
        return this.description != null ? this.description.getUsage() : "";
    }
}

