/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.impl;

import org.crsh.cmdline.matcher.impl.Termination;

public abstract class Token {
    final int index;
    final String raw;

    Token(int index, String raw) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (raw == null) {
            throw new NullPointerException();
        }
        this.index = index;
        this.raw = raw;
    }

    public int getFrom() {
        return this.index;
    }

    public int getTo() {
        return this.index + this.raw.length();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Token) {
            Token that = (Token)obj;
            return this.index == that.index && this.raw.equals(that.raw);
        }
        return false;
    }

    static abstract class Literal
    extends Token {
        final String value;
        final Termination termination;

        Literal(int index, String value) {
            this(index, value, value, Termination.DETERMINED);
        }

        Literal(int index, String raw, String value, Termination termination) {
            super(index, raw);
            if (value == null) {
                throw new NullPointerException();
            }
            if (termination == null) {
                throw new NullPointerException();
            }
            this.value = value;
            this.termination = termination;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass().equals(this.getClass())) {
                Literal that = (Literal)obj;
                return super.equals(obj) && this.index == that.index && this.value.equals(that.value) && this.termination == that.termination;
            }
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[index=" + this.index + ",raw=" + this.raw + ",value=" + this.value + ",termination=" + this.termination.name() + "]";
        }

        static final class Word
        extends Literal {
            Word(int index, String raw, String value, Termination termination) {
                super(index, raw, value, termination);
            }

            Word(int index, String value) {
                super(index, value);
            }
        }

        static abstract class Option
        extends Literal {
            private final String name;

            public final String getName() {
                return this.name;
            }

            Option(int index, String raw, String value, Termination termination, String name) {
                super(index, raw, value, termination);
                this.name = name;
            }

            static final class Long
            extends Option {
                Long(int index, String raw, String value, Termination termination) {
                    super(index, raw, value, termination, value.substring(2));
                }
            }

            static final class Short
            extends Option {
                Short(int index, String raw, String value, Termination termination) {
                    super(index, raw, value, termination, value.substring(1));
                }
            }
        }
    }

    static final class Whitespace
    extends Token {
        Whitespace(int index, String raw) {
            super(index, raw);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Whitespace) {
                Whitespace that = (Whitespace)obj;
                return super.equals(obj) && this.index == that.index;
            }
            return false;
        }

        public String toString() {
            return "Token.Whitespace[index=" + this.index + ",raw=" + this.raw + "]";
        }
    }
}

