/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.crsh.cmdline.ArgumentDescriptor;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandFactory;
import org.crsh.cmdline.IntrospectionException;
import org.crsh.cmdline.MethodDescriptor;
import org.crsh.cmdline.Multiplicity;
import org.crsh.cmdline.OptionDescriptor;
import org.crsh.cmdline.SimpleValueType;
import org.crsh.cmdline.annotations.Argument;
import org.crsh.cmdline.annotations.Command;
import org.crsh.cmdline.annotations.Option;

public class CommandInfoTestCase
extends TestCase {
    public void testCommandImplicitDescription() throws IntrospectionException {
        class A {
            A() {
            }
        }
        ClassDescriptor c = CommandFactory.create(A.class);
        CommandInfoTestCase.assertEquals((String)"", (String)c.getUsage());
        CommandInfoTestCase.assertEquals((int)0, (int)c.getArguments().size());
        CommandInfoTestCase.assertEquals((int)0, (int)c.getOptions().size());
    }

    public void testCommandDescription() throws IntrospectionException {
        class A {
            A() {
            }
        }
        ClassDescriptor c = CommandFactory.create(A.class);
        CommandInfoTestCase.assertEquals((String)"", (String)c.getUsage());
        CommandInfoTestCase.assertEquals((int)0, (int)c.getArguments().size());
        CommandInfoTestCase.assertEquals((int)0, (int)c.getOptions().size());
    }

    public void testOption() throws IntrospectionException {
        class A {
            @Option(names={"i"})
            private int i;

            A() {
            }
        }
        ClassDescriptor ai = CommandFactory.create(A.class);
        CommandInfoTestCase.assertEquals((int)1, (int)ai.getOptions().size());
        OptionDescriptor i = ai.getOption("-i");
        CommandInfoTestCase.assertEquals(Arrays.asList("i"), (Object)i.getNames());
    }

    public void testArgument1() throws IntrospectionException {
        class A {
            @Argument
            private int i;

            A() {
            }
        }
        ClassDescriptor c = CommandFactory.create(A.class);
        CommandInfoTestCase.assertEquals((int)1, (int)c.getArguments().size());
        ArgumentDescriptor i = (ArgumentDescriptor)c.getArguments().get(0);
        CommandInfoTestCase.assertEquals((Object)SimpleValueType.INTEGER, (Object)i.getType());
        CommandInfoTestCase.assertEquals((Object)Multiplicity.ZERO_OR_ONE, (Object)i.getMultiplicity());
    }

    public void testArgument2() throws IntrospectionException {
        class A {
            @Argument
            private int i;
            @Argument
            private List<Integer> j;

            A() {
            }
        }
        ClassDescriptor c = CommandFactory.create(A.class);
        CommandInfoTestCase.assertEquals((int)2, (int)c.getArguments().size());
        ArgumentDescriptor i = (ArgumentDescriptor)c.getArguments().get(0);
        CommandInfoTestCase.assertEquals((Object)SimpleValueType.INTEGER, (Object)i.getType());
        CommandInfoTestCase.assertEquals((Object)Multiplicity.ZERO_OR_ONE, (Object)i.getMultiplicity());
        ArgumentDescriptor j = (ArgumentDescriptor)c.getArguments().get(1);
        CommandInfoTestCase.assertEquals((Object)SimpleValueType.INTEGER, (Object)j.getType());
        CommandInfoTestCase.assertEquals((Object)Multiplicity.ZERO_OR_MORE, (Object)j.getMultiplicity());
    }

    public void testArgument3() throws IntrospectionException {
        try {
            class A {
                @Argument
                private List<Integer> i;
                @Argument
                private List<Integer> j;

                A() {
                }
            }
            CommandFactory.create(A.class);
            CommandInfoTestCase.fail();
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    public void testSub() throws IntrospectionException {
        class A {
            A() {
            }

            @Command
            void b() {
            }
        }
        ClassDescriptor a = CommandFactory.create(A.class);
        MethodDescriptor b = a.getMethod("b");
        CommandInfoTestCase.assertNotNull((Object)b);
    }

    public void testOverlappingOption() throws IntrospectionException {
        try {
            class A {
                @Option(names={"a"})
                String a;

                A() {
                }

                @Command
                void b(@Option(names={"a"}) String a) {
                }
            }
            CommandFactory.create(A.class);
            CommandInfoTestCase.fail();
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    public void testAnnotation() throws IntrospectionException {
        class A {
            @Level
            String l;

            A() {
            }
        }
        ClassDescriptor a = CommandFactory.create(A.class);
        CommandInfoTestCase.assertEquals((int)1, (int)a.getOptions().size());
        OptionDescriptor i = a.getOption("-l");
        CommandInfoTestCase.assertEquals(Arrays.asList("l"), (Object)i.getNames());
        CommandInfoTestCase.assertTrue((boolean)(i.getAnnotation() instanceof Level));
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Option(names={"l"})
    static @interface Level {
    }
}

