/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher;

import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandFactory;
import org.crsh.cmdline.annotations.Argument;
import org.crsh.cmdline.annotations.Command;
import org.crsh.cmdline.annotations.Option;
import org.crsh.cmdline.matcher.CmdCompletionException;
import org.crsh.cmdline.matcher.CompleterSupport;
import org.crsh.cmdline.matcher.Matcher;
import org.crsh.cmdline.matcher.ValueSupport;
import org.crsh.cmdline.spi.Completer;

public class CompleteTestCase
extends TestCase {
    public void testCompleterResolution() throws Exception {
        class A {
            A() {
            }

            @Command
            void m(@Argument String arg) {
            }

            @Command
            void n(@Argument(completer=CompleterSupport.Foo.class) String arg) {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher matcher = Matcher.createMatcher((ClassDescriptor)desc);
        CompleteTestCase.assertEquals(Collections.emptyMap(), (Object)matcher.complete("m fo"));
        CompleteTestCase.assertEquals(Collections.singletonMap("o", " "), (Object)matcher.complete("n fo"));
        CompleteTestCase.assertEquals(Collections.singletonMap("ab", ""), (Object)matcher.complete((Completer)new CompleterSupport.Echo(), "m ab"));
        CompleteTestCase.assertEquals(Collections.singletonMap("o", " "), (Object)matcher.complete((Completer)new CompleterSupport.Echo(), "n fo"));
    }

    public void testExplicitCommandSingleArgument() throws Exception {
        class A {
            A() {
            }

            @Command
            void m(@Argument(completer=CompleterSupport.Foo.class) String arg) {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher matcher = Matcher.createMatcher((ClassDescriptor)desc);
        CompleteTestCase.assertEquals(Collections.singletonMap("foo", " "), (Object)matcher.complete("m "));
        CompleteTestCase.assertEquals(Collections.singletonMap("oo", " "), (Object)matcher.complete("m f"));
        CompleteTestCase.assertEquals(Collections.singletonMap("o", " "), (Object)matcher.complete("m fo"));
        CompleteTestCase.assertEquals(Collections.emptyMap(), (Object)matcher.complete("m a "));
        CompleteTestCase.assertEquals(Collections.emptyMap(), (Object)matcher.complete("m a f"));
    }

    public void testImplicitCommandSingleArgument() throws Exception {
        class A {
            A() {
            }

            @Command
            void main(@Argument(completer=CompleterSupport.Foo.class) String arg) {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher matcher = Matcher.createMatcher((String)"main", (ClassDescriptor)desc);
        CompleteTestCase.assertEquals(Collections.singletonMap("foo", " "), (Object)matcher.complete(""));
        CompleteTestCase.assertEquals(Collections.singletonMap("oo", " "), (Object)matcher.complete("f"));
        CompleteTestCase.assertEquals(Collections.singletonMap("o", " "), (Object)matcher.complete("fo"));
        CompleteTestCase.assertEquals(Collections.emptyMap(), (Object)matcher.complete("a "));
        CompleteTestCase.assertEquals(Collections.emptyMap(), (Object)matcher.complete("a f"));
    }

    public void testMultiArgument() throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A {
            A() {
            }

            @Command
            void m(@Argument(completer=CompleterSupport.Foo.class) List<String> arg) {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher matcher = Matcher.createMatcher((ClassDescriptor)desc);
        CompleteTestCase.assertEquals(Collections.singletonMap("foo", " "), (Object)matcher.complete("m "));
        CompleteTestCase.assertEquals(Collections.singletonMap("oo", " "), (Object)matcher.complete("m f"));
        CompleteTestCase.assertEquals(Collections.singletonMap("o", " "), (Object)matcher.complete("m fo"));
        CompleteTestCase.assertEquals(Collections.singletonMap("foo", " "), (Object)matcher.complete("m a "));
        CompleteTestCase.assertEquals(Collections.singletonMap("oo", " "), (Object)matcher.complete("m a f"));
        CompleteTestCase.assertEquals(Collections.singletonMap("o", " "), (Object)matcher.complete("m a fo"));
    }

    public void testOption() throws Exception {
        class A {
            @Option(names={"a", "add", "addition"})
            String add;

            A() {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher matcher = Matcher.createMatcher((ClassDescriptor)desc);
        CompleteTestCase.assertEquals(Collections.singletonMap("a", " "), (Object)matcher.complete("-"));
        CompleteTestCase.assertEquals(Collections.singletonMap("", " "), (Object)matcher.complete("-a"));
        HashMap<String, String> a = new HashMap<String, String>();
        a.put("add", " ");
        a.put("addition", " ");
        HashMap<String, String> b = new HashMap<String, String>();
        b.put("d", " ");
        b.put("dition", " ");
        HashMap<String, String> c = new HashMap<String, String>();
        c.put("tion", " ");
        CompleteTestCase.assertEquals(a, (Object)matcher.complete("--"));
        CompleteTestCase.assertEquals(b, (Object)matcher.complete("--ad"));
        CompleteTestCase.assertEquals(c, (Object)matcher.complete("--addi"));
    }

    public void testDoubleDash() throws Exception {
        class A {
            A() {
            }

            @Command
            void main(@Option(names={"o"}) String o, @Argument(completer=CompleterSupport.Foo.class) String arg) {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher matcher = Matcher.createMatcher((String)"main", (ClassDescriptor)desc);
        CompleteTestCase.assertEquals(Collections.singletonMap("oo", " "), (Object)matcher.complete("-- f"));
    }

    public void testOptionValue() throws Exception {
        class A {
            @Option(names={"a"}, completer=CompleterSupport.Foo.class)
            String a;

            A() {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher matcher = Matcher.createMatcher((ClassDescriptor)desc);
        CompleteTestCase.assertEquals(Collections.singletonMap("foo", " "), (Object)matcher.complete("-a "));
        CompleteTestCase.assertEquals(Collections.singletonMap("oo", " "), (Object)matcher.complete("-a f"));
        CompleteTestCase.assertEquals(Collections.singletonMap("o", " "), (Object)matcher.complete("-a fo"));
        CompleteTestCase.assertEquals(Collections.emptyMap(), (Object)matcher.complete("-a -b"));
        CompleteTestCase.assertEquals(Collections.emptyMap(), (Object)matcher.complete("-a b "));
        CompleteTestCase.assertEquals(Collections.emptyMap(), (Object)matcher.complete("-a b c"));
    }

    public void testOptionArgument() throws Exception {
        class A {
            A() {
            }

            @Command
            void main(@Option(names={"o"}) String o, @Argument(completer=CompleterSupport.Foo.class) String arg) {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher matcher = Matcher.createMatcher((String)"main", (ClassDescriptor)desc);
        CompleteTestCase.assertEquals(Collections.singletonMap("foo", " "), (Object)matcher.complete("-o bar "));
        CompleteTestCase.assertEquals(Collections.singletonMap("oo", " "), (Object)matcher.complete("-o bar f"));
    }

    public void testCommand() throws Exception {
        class A {
            @Option(names={"a"})
            String a;

            A() {
            }

            @Command
            void foo(@Option(names={"b"}) String b) {
            }

            @Command
            void faa() {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher matcher = Matcher.createMatcher((String)"main", (ClassDescriptor)desc);
        HashMap<String, String> a = new HashMap<String, String>();
        a.put("foo", " ");
        a.put("faa", " ");
        HashMap<String, String> b = new HashMap<String, String>();
        b.put("oo", " ");
        b.put("aa", " ");
        Map<String, String> c = Collections.singletonMap("", " ");
        Map d = Collections.emptyMap();
        CompleteTestCase.assertEquals(a, (Object)matcher.complete(""));
        CompleteTestCase.assertEquals(b, (Object)matcher.complete("f"));
        CompleteTestCase.assertEquals(c, (Object)matcher.complete("foo"));
        CompleteTestCase.assertEquals(d, (Object)matcher.complete("foo "));
        CompleteTestCase.assertEquals(a, (Object)matcher.complete("-a a "));
        CompleteTestCase.assertEquals(b, (Object)matcher.complete("-a a f"));
        CompleteTestCase.assertEquals(c, (Object)matcher.complete("-a a foo"));
        CompleteTestCase.assertEquals(d, (Object)matcher.complete("-a a foo "));
    }

    public void testArgumentValuedMain() throws Exception {
        class A {
            A() {
            }

            @Command
            void main(@Argument(completer=CompleterSupport.Echo.class) String s) {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher matcher = Matcher.createMatcher((String)"main", (ClassDescriptor)desc);
        CompleteTestCase.assertEquals(Collections.singletonMap("", ""), (Object)matcher.complete(""));
        CompleteTestCase.assertEquals(Collections.singletonMap("m", ""), (Object)matcher.complete("m"));
        CompleteTestCase.assertEquals(Collections.singletonMap("ma", ""), (Object)matcher.complete("ma"));
        CompleteTestCase.assertEquals(Collections.singletonMap("mai", ""), (Object)matcher.complete("mai"));
        CompleteTestCase.assertEquals(Collections.singletonMap("main", ""), (Object)matcher.complete("main"));
        CompleteTestCase.assertEquals(Collections.emptyMap(), (Object)matcher.complete("main "));
        CompleteTestCase.assertEquals(Collections.emptyMap(), (Object)matcher.complete("main a"));
    }

    public void testEnum() throws Exception {
        class A {
            A() {
            }

            @Command
            void foo(@Option(names={"a"}) RetentionPolicy a) {
            }

            @Command
            void bar(@Argument RetentionPolicy a) {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher matcher = Matcher.createMatcher((ClassDescriptor)desc);
        HashMap<String, String> a = new HashMap<String, String>();
        a.put("SOURCE", " ");
        a.put("CLASS", " ");
        a.put("RUNTIME", " ");
        HashMap<String, String> b = new HashMap<String, String>();
        b.put("SOURCE", "\"");
        b.put("CLASS", "\"");
        b.put("RUNTIME", "\"");
        HashMap<String, String> c = new HashMap<String, String>();
        c.put("SOURCE", "'");
        c.put("CLASS", "'");
        c.put("RUNTIME", "'");
        Map<String, String> d = Collections.singletonMap("RCE", " ");
        Map<String, String> e = Collections.singletonMap("RCE", "\"");
        Map<String, String> f = Collections.singletonMap("RCE", "'");
        Map<String, String> g = Collections.singletonMap("", " ");
        Map<String, String> h = Collections.singletonMap("", " ");
        for (String m : Arrays.asList("foo -a", "bar")) {
            CompleteTestCase.assertEquals((String)("testing " + m), a, (Object)matcher.complete(m + " "));
            CompleteTestCase.assertEquals((String)("testing " + m), b, (Object)matcher.complete(m + " \""));
            CompleteTestCase.assertEquals((String)("testing " + m), c, (Object)matcher.complete(m + " '"));
            CompleteTestCase.assertEquals((String)("testing " + m), d, (Object)matcher.complete(m + " SOU"));
            CompleteTestCase.assertEquals((String)("testing " + m), e, (Object)matcher.complete(m + " \"SOU"));
            CompleteTestCase.assertEquals((String)("testing " + m), f, (Object)matcher.complete(m + " 'SOU"));
            CompleteTestCase.assertEquals((String)("testing " + m), g, (Object)matcher.complete(m + " SOURCE"));
            CompleteTestCase.assertEquals((String)("testing " + m), h, (Object)matcher.complete(m + " \"SOURCE\""));
        }
    }

    public void testCommandOption() throws Exception {
        class A {
            A() {
            }

            @Command
            void bar(@Option(names={"a"}, completer=CompleterSupport.Foo.class) String a) {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher matcher = Matcher.createMatcher((ClassDescriptor)desc);
        CompleteTestCase.assertEquals(Collections.singletonMap("bar", " "), (Object)matcher.complete(""));
        CompleteTestCase.assertEquals(Collections.singletonMap("ar", " "), (Object)matcher.complete("b"));
        CompleteTestCase.assertEquals(Collections.singletonMap("", " "), (Object)matcher.complete("bar"));
        CompleteTestCase.assertEquals(Collections.emptyMap(), (Object)matcher.complete("bar "));
        CompleteTestCase.assertEquals(Collections.singletonMap("foo", " "), (Object)matcher.complete("bar -a "));
        CompleteTestCase.assertEquals(Collections.singletonMap("oo", " "), (Object)matcher.complete("bar -a f"));
        CompleteTestCase.assertEquals(Collections.singletonMap("o", " "), (Object)matcher.complete("bar -a fo"));
    }

    public void testFailure() throws Exception {
        class A {
            A() {
            }

            @Command
            void foo(@Option(names={"a"}, completer=CompleterSupport.Exception.class) String a) {
            }
        }
        Matcher matcherA = Matcher.createMatcher((ClassDescriptor)CommandFactory.create(A.class));
        try {
            matcherA.complete("foo -a b");
            CompleteTestCase.fail();
        }
        catch (CmdCompletionException e) {
            // empty catch block
        }
        class B {
            B() {
            }

            @Command
            void foo(@Option(names={"a"}, completer=CompleterSupport.RuntimeException.class) String a) {
            }
        }
        Matcher matcherB = Matcher.createMatcher((ClassDescriptor)CommandFactory.create(B.class));
        try {
            matcherB.complete("foo -a b");
            CompleteTestCase.fail();
        }
        catch (CmdCompletionException e) {
            // empty catch block
        }
        class C {
            C() {
            }

            @Command
            void foo(@Option(names={"a"}, completer=CompleterSupport.Abstract.class) String a) {
            }
        }
        Matcher matcherC = Matcher.createMatcher((ClassDescriptor)CommandFactory.create(C.class));
        try {
            matcherC.complete("foo -a b");
            CompleteTestCase.fail();
        }
        catch (CmdCompletionException e) {
            // empty catch block
        }
    }

    public void testArgumentProvidedValue() throws Exception {
        class A {
            ValueSupport.Provided o;

            A() {
            }

            @Command
            public void foo(@Argument ValueSupport.Provided o) {
                this.o = o;
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher matcher = Matcher.createMatcher((ClassDescriptor)desc);
        CompleteTestCase.assertEquals(Collections.emptyMap(), (Object)matcher.complete("foo "));
    }
}

