/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.crsh.cmdline.ArgumentDescriptor;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandDescriptor;
import org.crsh.cmdline.MethodDescriptor;
import org.crsh.cmdline.Multiplicity;
import org.crsh.cmdline.OptionDescriptor;
import org.crsh.cmdline.matcher.impl.Event;
import org.crsh.cmdline.matcher.impl.Token;
import org.crsh.cmdline.matcher.impl.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Parser<T>
implements Iterator<Event> {
    private final Tokenizer tokenizer;
    private final String mainName;
    private final Mode mode;
    private CommandDescriptor<T, ?> command;
    private Status status;
    private final LinkedList<Event> next;

    public Parser(Tokenizer tokenizer, ClassDescriptor<T> command, String mainName, Mode mode) {
        this.tokenizer = tokenizer;
        this.command = command;
        this.mainName = mainName;
        this.status = new Status.ReadingOption();
        this.mode = mode;
        this.next = new LinkedList();
    }

    public Mode getMode() {
        return this.mode;
    }

    public int getIndex() {
        return this.tokenizer.getIndex();
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public boolean hasNext() {
        if (this.next.isEmpty()) {
            this.determine();
        }
        return this.next.size() > 0;
    }

    @Override
    public Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next.removeFirst();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void determine() {
        Token token = this.tokenizer.peek();
        while (this.next.isEmpty()) {
            Status nextStatus;
            block67: {
                Token.Literal literal;
                block68: {
                    block66: {
                        nextStatus = null;
                        if (!(this.status instanceof Status.ReadingOption)) break block66;
                        if (token == null) {
                            this.next.addLast(new Event.Stop.Done.Option(this.tokenizer.getIndex()));
                        } else if (token instanceof Token.Whitespace) {
                            this.next.addLast(new Event.Separator((Token.Whitespace)token));
                            this.tokenizer.next();
                        } else {
                            literal = (Token.Literal)token;
                            if (literal instanceof Token.Literal.Option) {
                                Token.Literal.Option optionToken = (Token.Literal.Option)literal;
                                if (optionToken.getName().length() == 0 && optionToken instanceof Token.Literal.Option.Long) {
                                    ClassDescriptor classCommand;
                                    MethodDescriptor m;
                                    this.tokenizer.next();
                                    this.next.addLast(new Event.DoubleDash((Token.Literal.Option.Long)optionToken));
                                    if (this.command instanceof ClassDescriptor && (m = (classCommand = (ClassDescriptor)this.command).getMethod(this.mainName)) != null) {
                                        this.command = m;
                                        this.next.addLast(new Event.Method.Implicit(m, optionToken));
                                    }
                                    nextStatus = new Status.WantReadArg();
                                } else {
                                    OptionDescriptor<?> desc = this.command.findOption(literal.value);
                                    if (desc != null) {
                                        this.tokenizer.next();
                                        int arity = desc.getArity();
                                        LinkedList<Token.Literal.Word> values = new LinkedList<Token.Literal.Word>();
                                        while (arity > 0 && this.tokenizer.hasNext()) {
                                            Token a = this.tokenizer.peek();
                                            if (a instanceof Token.Whitespace) {
                                                this.tokenizer.next();
                                                if (this.tokenizer.hasNext() && this.tokenizer.peek() instanceof Token.Literal.Word) continue;
                                                this.tokenizer.pushBack();
                                                break;
                                            }
                                            Token.Literal b = (Token.Literal)a;
                                            if (b instanceof Token.Literal.Word) {
                                                values.addLast((Token.Literal.Word)b);
                                                this.tokenizer.next();
                                                --arity;
                                                continue;
                                            }
                                            this.tokenizer.pushBack();
                                            break;
                                        }
                                        this.next.addLast(new Event.Option(desc, optionToken, values));
                                    } else if (this.command instanceof ClassDescriptor) {
                                        MethodDescriptor m = ((ClassDescriptor)this.command).getMethod(this.mainName);
                                        if (m != null) {
                                            desc = m.findOption(literal.value);
                                            if (desc != null) {
                                                this.command = m;
                                                this.next.addLast(new Event.Method.Implicit(m, literal));
                                            } else {
                                                this.next.addLast(new Event.Stop.Unresolved.NoSuchOption.Method(optionToken));
                                            }
                                        } else {
                                            this.next.addLast(new Event.Stop.Unresolved.NoSuchOption.Class(optionToken));
                                        }
                                    } else {
                                        this.next.addLast(new Event.Stop.Unresolved.NoSuchOption.Method(optionToken));
                                    }
                                }
                            } else {
                                Token.Literal.Word wordLiteral = (Token.Literal.Word)literal;
                                if (this.command instanceof ClassDescriptor) {
                                    ClassDescriptor classCommand = (ClassDescriptor)this.command;
                                    MethodDescriptor m = classCommand.getMethod(wordLiteral.value);
                                    if (m != null && !m.getName().equals(this.mainName)) {
                                        this.command = m;
                                        this.tokenizer.next();
                                        this.next.addLast(new Event.Method.Explicit(m, wordLiteral));
                                    } else {
                                        m = classCommand.getMethod(this.mainName);
                                        if (m != null) {
                                            this.next.addLast(new Event.Method.Implicit(m, wordLiteral));
                                            nextStatus = new Status.WantReadArg();
                                            this.command = m;
                                        } else {
                                            nextStatus = new Status.WantReadArg();
                                        }
                                    }
                                } else {
                                    nextStatus = new Status.WantReadArg();
                                }
                            }
                        }
                        break block67;
                    }
                    if (!(this.status instanceof Status.WantReadArg)) break block68;
                    switch (this.mode) {
                        case INVOKE: {
                            nextStatus = new Status.ComputeArg();
                            break block67;
                        }
                        case COMPLETE: {
                            nextStatus = new Status.ReadingArg();
                            break block67;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                if (this.status instanceof Status.ReadingArg) {
                    if (token == null) {
                        this.next.addLast(new Event.Stop.Done.Arg(this.tokenizer.getIndex()));
                    } else if (token instanceof Token.Whitespace) {
                        this.next.addLast(new Event.Separator((Token.Whitespace)token));
                        this.tokenizer.next();
                    } else {
                        literal = (Token.Literal)token;
                        List<ArgumentDescriptor<?>> arguments = this.command.getArguments();
                        Status.ReadingArg ra = (Status.ReadingArg)this.status;
                        if (ra.index < arguments.size()) {
                            ArgumentDescriptor<?> argument = arguments.get(ra.index);
                            switch (argument.getMultiplicity()) {
                                case ZERO_OR_ONE: 
                                case ONE: {
                                    this.tokenizer.next();
                                    this.next.addLast(new Event.Argument(argument, Arrays.asList(literal)));
                                    nextStatus = ra.next();
                                    break;
                                }
                                case ZERO_OR_MORE: {
                                    this.tokenizer.next();
                                    ArrayList<Token.Literal> values = new ArrayList<Token.Literal>();
                                    values.add(literal);
                                    while (this.tokenizer.hasNext()) {
                                        Token capture = this.tokenizer.next();
                                        if (capture instanceof Token.Literal) {
                                            values.add((Token.Literal)capture);
                                            continue;
                                        }
                                        if (this.tokenizer.hasNext()) continue;
                                        this.tokenizer.pushBack();
                                        break;
                                    }
                                    this.next.addLast(new Event.Argument(argument, (List<Token.Literal>)values));
                                }
                            }
                        } else {
                            this.next.addLast(new Event.Stop.Unresolved.TooManyArguments(literal));
                        }
                    }
                } else if (this.status instanceof Status.ComputeArg) {
                    if (token == null) {
                        this.next.addLast(new Event.Stop.Done.Arg(this.tokenizer.getIndex()));
                    } else if (token instanceof Token.Whitespace) {
                        this.next.addLast(new Event.Separator((Token.Whitespace)token));
                        this.tokenizer.next();
                    } else {
                        List<ArgumentDescriptor<?>> arguments = this.command.getArguments();
                        int tokenCount = 0;
                        int wordCount = 0;
                        do {
                            Token t;
                            if ((t = this.tokenizer.next()) instanceof Token.Literal) {
                                ++wordCount;
                            }
                            ++tokenCount;
                        } while (this.tokenizer.hasNext());
                        this.tokenizer.pushBack(tokenCount);
                        int oneCount = 0;
                        int zeroOrOneCount = 0;
                        int index = 0;
                        for (ArgumentDescriptor<?> argument : arguments) {
                            Multiplicity multiplicity = argument.getMultiplicity();
                            if (multiplicity == Multiplicity.ONE) {
                                if (oneCount + 1 > wordCount) break;
                                ++oneCount;
                            } else if (multiplicity == Multiplicity.ZERO_OR_ONE) {
                                ++zeroOrOneCount;
                            }
                            ++index;
                        }
                        arguments = arguments.subList(0, index);
                        int toConsume = wordCount - oneCount;
                        zeroOrOneCount = Math.min(zeroOrOneCount, toConsume);
                        toConsume -= zeroOrOneCount;
                        LinkedList<Event> events = new LinkedList<Event>();
                        for (ArgumentDescriptor<?> argument : arguments) {
                            int size;
                            switch (argument.getMultiplicity()) {
                                case ONE: {
                                    size = 1;
                                    break;
                                }
                                case ZERO_OR_ONE: {
                                    if (zeroOrOneCount > 0) {
                                        --zeroOrOneCount;
                                        size = 1;
                                        break;
                                    }
                                    size = 0;
                                    break;
                                }
                                case ZERO_OR_MORE: {
                                    size = toConsume;
                                    toConsume = 0;
                                    break;
                                }
                                default: {
                                    throw new AssertionError();
                                }
                            }
                            if (size <= 0) continue;
                            ArrayList<Token.Literal> values = new ArrayList<Token.Literal>(size);
                            while (size > 0) {
                                Token t = this.tokenizer.next();
                                if (!(t instanceof Token.Literal)) continue;
                                values.add((Token.Literal)t);
                                --size;
                            }
                            events.addLast(new Event.Argument(argument, (List<Token.Literal>)values));
                            if (!this.tokenizer.hasNext() || !(this.tokenizer.peek() instanceof Token.Whitespace)) continue;
                            events.addLast(new Event.Separator((Token.Whitespace)this.tokenizer.next()));
                        }
                        events.addLast(new Event.Stop.Done.Arg(this.tokenizer.getIndex()));
                        nextStatus = new Status.Done();
                        this.next.addAll(events);
                    }
                } else {
                    if (this.status instanceof Status.Done) {
                        throw new IllegalStateException();
                    }
                    throw new AssertionError();
                }
            }
            if (nextStatus == null) continue;
            this.status = nextStatus;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        INVOKE,
        COMPLETE;

    }

    private static abstract class Status {
        private Status() {
        }

        private static class ReadingArg
        extends Status {
            final int index;

            ReadingArg() {
                this(0);
            }

            private ReadingArg(int index) {
                this.index = index;
            }

            ReadingArg next() {
                return new ReadingArg(this.index + 1);
            }
        }

        private static class Done
        extends Status {
            private Done() {
            }
        }

        private static class ComputeArg
        extends Status {
            private ComputeArg() {
            }
        }

        private static class WantReadArg
        extends Status {
            private WantReadArg() {
            }
        }

        private static class ReadingOption
        extends Status {
            private ReadingOption() {
            }
        }
    }
}

