/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.crsh.cmdline.CommandDescriptor;
import org.crsh.cmdline.matcher.CmdCompletionException;
import org.crsh.cmdline.matcher.impl.Completion;
import org.crsh.cmdline.matcher.tokenizer.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OptionCompletion<T>
extends Completion {
    private final CommandDescriptor<T, ?> descriptor;
    private final Token.Literal.Option prefix;

    OptionCompletion(CommandDescriptor<T, ?> descriptor, Token.Literal.Option prefix) {
        this.descriptor = descriptor;
        this.prefix = prefix;
    }

    @Override
    protected Map<String, String> complete() throws CmdCompletionException {
        HashMap<String, String> completions = new HashMap<String, String>();
        Set<String> optionNames = this.prefix instanceof Token.Literal.Option.Short ? this.descriptor.getShortOptionNames() : this.descriptor.getLongOptionNames();
        for (String optionName : optionNames) {
            if (!optionName.startsWith(this.prefix.getValue())) continue;
            completions.put(optionName.substring(this.prefix.getValue().length()), " ");
        }
        return completions;
    }
}

