/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.crsh.cmdline.EmptyCompleter;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.matcher.CmdCompletionException;
import org.crsh.cmdline.matcher.impl.Completion;
import org.crsh.cmdline.matcher.tokenizer.Termination;
import org.crsh.cmdline.spi.Completer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterCompletion
extends Completion {
    private final String prefix;
    private final Termination termination;
    private final ParameterDescriptor<?> parameter;
    private final Completer completer;

    ParameterCompletion(String prefix, Termination termination, ParameterDescriptor<?> parameter, Completer completer) {
        this.prefix = prefix;
        this.termination = termination;
        this.parameter = parameter;
        this.completer = completer;
    }

    @Override
    Map<String, String> complete() throws CmdCompletionException {
        Class<Completer> completerType = this.parameter.getCompleterType();
        Completer completer = this.completer;
        if (completerType != EmptyCompleter.class) {
            try {
                completer = completerType.newInstance();
            }
            catch (Exception e) {
                throw new CmdCompletionException(e);
            }
        }
        if (completer != null) {
            try {
                Map<String, Boolean> res = completer.complete(this.parameter, this.prefix);
                HashMap<String, String> delimiter = new HashMap<String, String>();
                for (Map.Entry<String, Boolean> entry : res.entrySet()) {
                    delimiter.put(entry.getKey(), entry.getValue() != false ? this.termination.getEnd() : "");
                }
                return delimiter;
            }
            catch (Exception e) {
                throw new CmdCompletionException(e);
            }
        }
        return Collections.emptyMap();
    }
}

