/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandFactory;
import org.crsh.cmdline.annotations.Argument;
import org.crsh.cmdline.annotations.Option;
import org.crsh.cmdline.matcher.Matcher;

public class EscapeTestCase
extends TestCase {
    public void testOption() throws Exception {
        class A {
            @Option(names={"o"})
            String s;

            A() {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher analyzer = desc.matcher();
        A a = new A();
        analyzer.match("-o \" \"").invoke((Object)a);
        EscapeTestCase.assertEquals((String)" ", (String)a.s);
        a = new A();
        analyzer.match("-o \"'\"").invoke((Object)a);
        EscapeTestCase.assertEquals((String)"'", (String)a.s);
        a = new A();
        analyzer.match("-o \" a b").invoke((Object)a);
        EscapeTestCase.assertEquals((String)" a b", (String)a.s);
    }

    public void testArgumentList() throws Exception {
        class A {
            @Argument
            List<String> s;

            A() {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher analyzer = desc.matcher();
        A a = new A();
        analyzer.match("\" \" b").invoke((Object)a);
        EscapeTestCase.assertEquals(Arrays.asList(" ", "b"), a.s);
        a = new A();
        analyzer.match("\"'\" b").invoke((Object)a);
        EscapeTestCase.assertEquals(Arrays.asList("'", "b"), a.s);
        a = new A();
        analyzer.match("\"a b\" c").invoke((Object)a);
        EscapeTestCase.assertEquals(Arrays.asList("a b", "c"), a.s);
    }
}

