/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline;

import java.lang.annotation.RetentionPolicy;
import java.util.List;
import junit.framework.TestCase;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandFactory;
import org.crsh.cmdline.IllegalParameterException;
import org.crsh.cmdline.IllegalValueTypeException;
import org.crsh.cmdline.IntrospectionException;
import org.crsh.cmdline.Multiplicity;
import org.crsh.cmdline.OptionDescriptor;
import org.crsh.cmdline.annotations.Option;
import org.crsh.cmdline.type.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionTestCase
extends TestCase {
    public void testIllegalParameter() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            List<Boolean> o;

            A() {
            }
        }
        this.assertIllegalParameter(A.class);
    }

    public void testIllegalTypes() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            Exception o;

            A() {
            }
        }
        this.assertIllegalValueType(A.class);
        class B {
            @Option(names={"o"})
            List<Exception> o;

            B() {
            }
        }
        this.assertIllegalValueType(B.class);
        class C {
            @Option(names={"o"})
            double o;

            C() {
            }
        }
        this.assertIllegalValueType(C.class);
        class D {
            @Option(names={"o"})
            Double o;

            D() {
            }
        }
        this.assertIllegalValueType(D.class);
        class E {
            @Option(names={"o"})
            List<Double> o;

            E() {
            }
        }
        this.assertIllegalValueType(E.class);
    }

    public void testOptionIntType() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            int o;

            A() {
            }
        }
        ClassDescriptor c = CommandFactory.DEFAULT.create(A.class);
        OptionDescriptor i = c.getOption("-o");
        OptionTestCase.assertEquals((Object)Multiplicity.SINGLE, (Object)i.getMultiplicity());
        OptionTestCase.assertEquals((boolean)false, (boolean)i.isRequired());
        OptionTestCase.assertEquals((Object)ValueType.INTEGER, (Object)i.getType());
    }

    public void testOptionIntWrapperType() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            Integer o;

            A() {
            }
        }
        ClassDescriptor c = CommandFactory.DEFAULT.create(A.class);
        OptionDescriptor i = c.getOption("-o");
        OptionTestCase.assertEquals((Object)Multiplicity.SINGLE, (Object)i.getMultiplicity());
        OptionTestCase.assertEquals((boolean)false, (boolean)i.isRequired());
        OptionTestCase.assertEquals((Object)ValueType.INTEGER, (Object)i.getType());
    }

    public void testOptionIntListType() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            List<Integer> o;

            A() {
            }
        }
        ClassDescriptor c = CommandFactory.DEFAULT.create(A.class);
        OptionDescriptor i = c.getOption("-o");
        OptionTestCase.assertEquals((Object)Multiplicity.MULTI, (Object)i.getMultiplicity());
        OptionTestCase.assertEquals((Object)ValueType.INTEGER, (Object)i.getType());
    }

    public void testOptionStringType() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            String o;

            A() {
            }
        }
        ClassDescriptor c = CommandFactory.DEFAULT.create(A.class);
        OptionDescriptor i = c.getOption("-o");
        OptionTestCase.assertEquals((Object)Multiplicity.SINGLE, (Object)i.getMultiplicity());
        OptionTestCase.assertEquals((boolean)false, (boolean)i.isRequired());
        OptionTestCase.assertEquals((Object)ValueType.STRING, (Object)i.getType());
    }

    public void testOptionStringListType() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            List<String> o;

            A() {
            }
        }
        ClassDescriptor c = CommandFactory.DEFAULT.create(A.class);
        OptionDescriptor i = c.getOption("-o");
        OptionTestCase.assertEquals((Object)Multiplicity.MULTI, (Object)i.getMultiplicity());
        OptionTestCase.assertEquals((Object)ValueType.STRING, (Object)i.getType());
    }

    public void testOptionBooleanType() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            boolean o;

            A() {
            }
        }
        ClassDescriptor c = CommandFactory.DEFAULT.create(A.class);
        OptionDescriptor i = c.getOption("-o");
        OptionTestCase.assertEquals((Object)Multiplicity.SINGLE, (Object)i.getMultiplicity());
        OptionTestCase.assertEquals((boolean)false, (boolean)i.isRequired());
        OptionTestCase.assertEquals((Object)ValueType.BOOLEAN, (Object)i.getType());
    }

    public void testOptionBooleanWrapperType() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            Boolean o;

            A() {
            }
        }
        ClassDescriptor c = CommandFactory.DEFAULT.create(A.class);
        OptionDescriptor i = c.getOption("-o");
        OptionTestCase.assertEquals((Object)Multiplicity.SINGLE, (Object)i.getMultiplicity());
        OptionTestCase.assertEquals((boolean)false, (boolean)i.isRequired());
        OptionTestCase.assertEquals((Object)ValueType.BOOLEAN, (Object)i.getType());
    }

    public void testOptionEnumType() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            RetentionPolicy o;

            A() {
            }
        }
        ClassDescriptor c = CommandFactory.DEFAULT.create(A.class);
        OptionDescriptor i = c.getOption("-o");
        OptionTestCase.assertEquals((Object)Multiplicity.SINGLE, (Object)i.getMultiplicity());
        OptionTestCase.assertEquals((boolean)false, (boolean)i.isRequired());
        OptionTestCase.assertEquals((Object)ValueType.ENUM, (Object)i.getType());
    }

    private void assertIllegalValueType(Class<?> type) throws IntrospectionException {
        try {
            CommandFactory.DEFAULT.create(type);
            OptionTestCase.fail();
        }
        catch (IllegalValueTypeException illegalValueTypeException) {
            // empty catch block
        }
    }

    private void assertIllegalParameter(Class<?> type) throws IntrospectionException {
        try {
            CommandFactory.DEFAULT.create(type);
            OptionTestCase.fail();
        }
        catch (IllegalParameterException illegalParameterException) {
            // empty catch block
        }
    }
}

