/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher;

import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandCompletion;
import org.crsh.cmdline.CommandFactory;
import org.crsh.cmdline.Delimiter;
import org.crsh.cmdline.annotations.Argument;
import org.crsh.cmdline.annotations.Command;
import org.crsh.cmdline.annotations.Option;
import org.crsh.cmdline.matcher.CmdCompletionException;
import org.crsh.cmdline.matcher.CompleterSupport;
import org.crsh.cmdline.matcher.Custom;
import org.crsh.cmdline.matcher.Matcher;
import org.crsh.cmdline.spi.Completer;
import org.crsh.cmdline.spi.Completion;

public class CompleteTestCase
extends TestCase {
    public void testCompleterResolution() throws Exception {
        class A {
            A() {
            }

            @Command
            void m(@Argument String arg) {
            }

            @Command
            void n(@Argument(completer=CompleterSupport.Foo.class) String arg) {
            }
        }
        ClassDescriptor desc = CommandFactory.DEFAULT.create(A.class);
        Matcher matcher = desc.matcher();
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create()), (Object)matcher.complete("m fo"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"o", (boolean)true)), (Object)matcher.complete("n fo"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"ab", (boolean)false)), (Object)matcher.complete((Completer)new CompleterSupport.Echo(), "m ab"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"o", (boolean)true)), (Object)matcher.complete((Completer)new CompleterSupport.Echo(), "n fo"));
    }

    public void testExplicitCommandSingleArgument() throws Exception {
        class A {
            A() {
            }

            @Command
            void m(@Argument(completer=CompleterSupport.Foo.class) String arg) {
            }
        }
        ClassDescriptor desc = CommandFactory.DEFAULT.create(A.class);
        Matcher matcher = desc.matcher();
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"foo", (boolean)true)), (Object)matcher.complete("m "));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"oo", (boolean)true)), (Object)matcher.complete("m f"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"o", (boolean)true)), (Object)matcher.complete("m fo"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create()), (Object)matcher.complete("m a "));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create()), (Object)matcher.complete("m a f"));
    }

    public void testImplicitCommandSingleArgument() throws Exception {
        class A {
            A() {
            }

            @Command
            void main(@Argument(completer=CompleterSupport.Foo.class) String arg) {
            }
        }
        ClassDescriptor desc = CommandFactory.DEFAULT.create(A.class);
        Matcher matcher = desc.matcher("main");
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"foo", (boolean)true)), (Object)matcher.complete(""));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"oo", (boolean)true)), (Object)matcher.complete("f"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"o", (boolean)true)), (Object)matcher.complete("fo"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create()), (Object)matcher.complete("a "));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create()), (Object)matcher.complete("a f"));
    }

    public void testSecondArgument() throws Exception {
        class A {
            A() {
            }

            @Command
            void main(@Argument String arg1, @Argument(completer=CompleterSupport.Foo.class) String arg2) {
            }
        }
        ClassDescriptor desc = CommandFactory.DEFAULT.create(A.class);
        Matcher matcher = desc.matcher("main");
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"foo", (boolean)true)), (Object)matcher.complete("foo "));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.DOUBLE_QUOTE, Completion.create((String)"foo", (boolean)true)), (Object)matcher.complete("foo \""));
    }

    public void testMultiArgument() throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A {
            A() {
            }

            @Command
            void m(@Argument(completer=CompleterSupport.Foo.class) List<String> arg) {
            }
        }
        ClassDescriptor desc = CommandFactory.DEFAULT.create(A.class);
        Matcher matcher = desc.matcher();
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"foo", (boolean)true)), (Object)matcher.complete("m "));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"oo", (boolean)true)), (Object)matcher.complete("m f"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"o", (boolean)true)), (Object)matcher.complete("m fo"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"foo", (boolean)true)), (Object)matcher.complete("m a "));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"oo", (boolean)true)), (Object)matcher.complete("m a f"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"o", (boolean)true)), (Object)matcher.complete("m a fo"));
    }

    public void testOption() throws Exception {
        class A {
            @Option(names={"a", "add", "addition"})
            String add;

            A() {
            }
        }
        ClassDescriptor desc = CommandFactory.DEFAULT.create(A.class);
        Matcher matcher = desc.matcher();
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"-", (String)"a", (boolean)true)), (Object)matcher.complete("-"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"", (boolean)true)), (Object)matcher.complete("-a"));
        CommandCompletion a = new CommandCompletion(Delimiter.EMPTY, Completion.builder((String)"--").add("add", true).add("addition", true).build());
        CommandCompletion b = new CommandCompletion(Delimiter.EMPTY, Completion.builder((String)"--ad").add("d", true).add("dition", true).build());
        CommandCompletion c = new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"--addi", (String)"tion", (boolean)true));
        CompleteTestCase.assertEquals((Object)a, (Object)matcher.complete("--"));
        CompleteTestCase.assertEquals((Object)b, (Object)matcher.complete("--ad"));
        CompleteTestCase.assertEquals((Object)c, (Object)matcher.complete("--addi"));
    }

    public void testDoubleDash() throws Exception {
        class A {
            A() {
            }

            @Command
            void main(@Option(names={"o"}) String o, @Argument(completer=CompleterSupport.Foo.class) String arg) {
            }
        }
        ClassDescriptor desc = CommandFactory.DEFAULT.create(A.class);
        Matcher matcher = desc.matcher("main");
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"oo", (boolean)true)), (Object)matcher.complete("-- f"));
    }

    public void testOptionValue() throws Exception {
        class A {
            @Option(names={"a"}, completer=CompleterSupport.Foo.class)
            String a;

            A() {
            }
        }
        ClassDescriptor desc = CommandFactory.DEFAULT.create(A.class);
        Matcher matcher = desc.matcher();
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"foo", (boolean)true)), (Object)matcher.complete("-a "));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"oo", (boolean)true)), (Object)matcher.complete("-a f"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"o", (boolean)true)), (Object)matcher.complete("-a fo"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"-b")), (Object)matcher.complete("-a -b"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create()), (Object)matcher.complete("-a b "));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"c")), (Object)matcher.complete("-a b c"));
    }

    public void testImplicitCommandOptionName() throws Exception {
        class A {
            A() {
            }

            @Command
            void main(@Option(names={"o", "option"}) String o) {
            }
        }
        ClassDescriptor desc = CommandFactory.DEFAULT.create(A.class);
        Matcher matcher = desc.matcher("main");
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"-", (String)"o", (boolean)true)), (Object)matcher.complete("-"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"--", (String)"option", (boolean)true)), (Object)matcher.complete("--"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"--o", (String)"ption", (boolean)true)), (Object)matcher.complete("--o"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"--op", (String)"tion", (boolean)true)), (Object)matcher.complete("--op"));
    }

    public void testOptionArgument() throws Exception {
        class A {
            A() {
            }

            @Command
            void main(@Option(names={"o"}) String o, @Argument(completer=CompleterSupport.Foo.class) String arg) {
            }
        }
        ClassDescriptor desc = CommandFactory.DEFAULT.create(A.class);
        Matcher matcher = desc.matcher("main");
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"foo", (boolean)true)), (Object)matcher.complete("-o bar "));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"oo", (boolean)true)), (Object)matcher.complete("-o bar f"));
    }

    public void testCommand() throws Exception {
        class A {
            @Option(names={"a"})
            String a;

            A() {
            }

            @Command
            void foo(@Option(names={"b"}) String b) {
            }

            @Command
            void faa() {
            }
        }
        ClassDescriptor desc = CommandFactory.DEFAULT.create(A.class);
        Matcher matcher = desc.matcher("main");
        CommandCompletion a = new CommandCompletion(Delimiter.EMPTY, Completion.builder((String)"").add("foo", true).add("faa", true).build());
        CommandCompletion b = new CommandCompletion(Delimiter.EMPTY, Completion.builder((String)"f").add("oo", true).add("aa", true).build());
        CommandCompletion c = new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"", (boolean)true));
        CommandCompletion d = new CommandCompletion(Delimiter.EMPTY, Completion.create());
        CompleteTestCase.assertEquals((Object)a, (Object)matcher.complete(""));
        CompleteTestCase.assertEquals((Object)b, (Object)matcher.complete("f"));
        CompleteTestCase.assertEquals((Object)c, (Object)matcher.complete("foo"));
        CompleteTestCase.assertEquals((Object)d, (Object)matcher.complete("foo "));
        CompleteTestCase.assertEquals((Object)a, (Object)matcher.complete("-a a "));
        CompleteTestCase.assertEquals((Object)b, (Object)matcher.complete("-a a f"));
        CompleteTestCase.assertEquals((Object)c, (Object)matcher.complete("-a a foo"));
        CompleteTestCase.assertEquals((Object)d, (Object)matcher.complete("-a a foo "));
    }

    public void testArgumentValuedMain() throws Exception {
        class A {
            A() {
            }

            @Command
            void main(@Argument(completer=CompleterSupport.Echo.class) String s) {
            }
        }
        ClassDescriptor desc = CommandFactory.DEFAULT.create(A.class);
        Matcher matcher = desc.matcher("main");
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"", (boolean)false)), (Object)matcher.complete(""));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"m", (boolean)false)), (Object)matcher.complete("m"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"ma", (boolean)false)), (Object)matcher.complete("ma"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"mai", (boolean)false)), (Object)matcher.complete("mai"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"main", (boolean)false)), (Object)matcher.complete("main"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create()), (Object)matcher.complete("main "));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create()), (Object)matcher.complete("main a"));
    }

    public void testEnum() throws Exception {
        class A {
            A() {
            }

            @Command
            void foo(@Option(names={"a"}) RetentionPolicy a) {
            }

            @Command
            void bar(@Argument RetentionPolicy a) {
            }
        }
        ClassDescriptor desc = CommandFactory.DEFAULT.create(A.class);
        Matcher matcher = desc.matcher();
        CommandCompletion a = new CommandCompletion(Delimiter.EMPTY, Completion.builder((String)"").add("SOURCE", true).add("CLASS", true).add("RUNTIME", true).build());
        CommandCompletion b = new CommandCompletion(Delimiter.DOUBLE_QUOTE, Completion.builder((String)"").add("SOURCE", true).add("CLASS", true).add("RUNTIME", true).build());
        CommandCompletion c = new CommandCompletion(Delimiter.SINGLE_QUOTE, Completion.builder((String)"").add("SOURCE", true).add("CLASS", true).add("RUNTIME", true).build());
        CommandCompletion d = new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"SOU", (String)"RCE", (boolean)true));
        CommandCompletion e = new CommandCompletion(Delimiter.DOUBLE_QUOTE, Completion.create((String)"SOU", (String)"RCE", (boolean)true));
        CommandCompletion f = new CommandCompletion(Delimiter.SINGLE_QUOTE, Completion.create((String)"SOU", (String)"RCE", (boolean)true));
        CommandCompletion g = new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"SOURCE", (String)"", (boolean)true));
        CommandCompletion h = new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"SOURCE", (String)"", (boolean)true));
        for (String m : Arrays.asList("foo -a", "bar")) {
            CompleteTestCase.assertEquals((String)("testing " + m), (Object)a, (Object)matcher.complete(m + " "));
            CompleteTestCase.assertEquals((String)("testing " + m), (Object)b, (Object)matcher.complete(m + " \""));
            CompleteTestCase.assertEquals((String)("testing " + m), (Object)c, (Object)matcher.complete(m + " '"));
            CompleteTestCase.assertEquals((String)("testing " + m), (Object)d, (Object)matcher.complete(m + " SOU"));
            CompleteTestCase.assertEquals((String)("testing " + m), (Object)e, (Object)matcher.complete(m + " \"SOU"));
            CompleteTestCase.assertEquals((String)("testing " + m), (Object)f, (Object)matcher.complete(m + " 'SOU"));
            CompleteTestCase.assertEquals((String)("testing " + m), (Object)g, (Object)matcher.complete(m + " SOURCE"));
            CompleteTestCase.assertEquals((String)("testing " + m), (Object)h, (Object)matcher.complete(m + " \"SOURCE\""));
        }
    }

    public void testCommandOption() throws Exception {
        class A {
            A() {
            }

            @Command
            void bar(@Option(names={"a"}, completer=CompleterSupport.Foo.class) String a) {
            }
        }
        ClassDescriptor desc = CommandFactory.DEFAULT.create(A.class);
        Matcher matcher = desc.matcher();
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"bar", (boolean)true)), (Object)matcher.complete(""));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"b", (String)"ar", (boolean)true)), (Object)matcher.complete("b"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"", (boolean)true)), (Object)matcher.complete("bar"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create()), (Object)matcher.complete("bar "));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"foo", (boolean)true)), (Object)matcher.complete("bar -a "));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"oo", (boolean)true)), (Object)matcher.complete("bar -a f"));
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create((String)"o", (boolean)true)), (Object)matcher.complete("bar -a fo"));
    }

    public void testFailure() throws Exception {
        class A {
            A() {
            }

            @Command
            void foo(@Option(names={"a"}, completer=CompleterSupport.Exception.class) String a) {
            }
        }
        Matcher matcherA = CommandFactory.DEFAULT.create(A.class).matcher();
        try {
            matcherA.complete("foo -a b");
            CompleteTestCase.fail();
        }
        catch (CmdCompletionException e) {
            // empty catch block
        }
        class B {
            B() {
            }

            @Command
            void foo(@Option(names={"a"}, completer=CompleterSupport.RuntimeException.class) String a) {
            }
        }
        Matcher matcherB = CommandFactory.DEFAULT.create(B.class).matcher();
        try {
            matcherB.complete("foo -a b");
            CompleteTestCase.fail();
        }
        catch (CmdCompletionException e) {
            // empty catch block
        }
        class C {
            C() {
            }

            @Command
            void foo(@Option(names={"a"}, completer=CompleterSupport.Abstract.class) String a) {
            }
        }
        Matcher matcherC = CommandFactory.DEFAULT.create(C.class).matcher();
        try {
            matcherC.complete("foo -a b");
            CompleteTestCase.fail();
        }
        catch (CmdCompletionException e) {
            // empty catch block
        }
    }

    public void testArgumentProvidedValue() throws Exception {
        class A {
            Custom o;

            A() {
            }

            @Command
            public void foo(@Argument Custom o) {
                this.o = o;
            }
        }
        ClassDescriptor desc = new CommandFactory(CompleteTestCase.class.getClassLoader()).create(A.class);
        Matcher matcher = desc.matcher();
        CompleteTestCase.assertEquals((Object)new CommandCompletion(Delimiter.EMPTY, Completion.create()), (Object)matcher.complete("foo "));
    }
}

