/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term;

import java.io.IOException;
import org.crsh.shell.connector.Connector;
import org.crsh.shell.connector.ConnectorResponseContext;
import org.crsh.term.TermAction;
import org.crsh.term.TermProcessor;
import org.crsh.term.TermResponseContext;
import org.crsh.term.TermShellAdapter;
import org.crsh.term.TermStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermShellAdapter
implements TermProcessor {
    private final Logger log = LoggerFactory.getLogger(TermShellAdapter.class);
    private final Connector connector;
    private volatile TermStatus status;

    public TermShellAdapter(Connector connector) {
        this.connector = connector;
        this.status = TermStatus.READY;
    }

    public String getPrompt() {
        return this.connector.getPrompt();
    }

    public TermStatus getStatus() {
        return this.status;
    }

    public void close() {
    }

    public boolean process(TermAction action, TermResponseContext responseContext) {
        try {
            return this._process(action, responseContext);
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }

    private boolean _process(TermAction action, TermResponseContext responseContext) throws IOException {
        boolean processed;
        if (action instanceof TermAction.Init) {
            String welcome = this.connector.open();
            responseContext.write(welcome);
            return true;
        }
        switch (2.$SwitchMap$org$crsh$term$TermStatus[this.status.ordinal()]) {
            case 1: {
                if (action instanceof TermAction.ReadLine) {
                    String line = ((TermAction.ReadLine)action).getLine();
                    this.status = TermStatus.PROCESSING;
                    this.log.debug("Submitting command " + line);
                    this.connector.submitEvaluation(line, (ConnectorResponseContext)new /* Unavailable Anonymous Inner Class!! */);
                } else if (action instanceof TermAction.CancelEvaluation) {
                    responseContext.done(false);
                }
                processed = true;
                break;
            }
            case 2: {
                processed = false;
                break;
            }
            case 3: {
                if (action instanceof TermAction.CancelEvaluation) {
                    if (this.connector.cancelEvalutation()) {
                        this.log.debug("Evaluation cancelled");
                    } else {
                        this.log.debug("Attempt to cancel evaluation failed");
                    }
                    responseContext.done(false);
                } else {
                    this.log.debug("Ignoring action " + action);
                }
                processed = true;
                break;
            }
            case 4: {
                throw new AssertionError((Object)"maybe todo");
            }
            default: {
                throw new AssertionError();
            }
        }
        return processed;
    }

    static /* synthetic */ Logger access$000(TermShellAdapter x0) {
        return x0.log;
    }

    static /* synthetic */ TermStatus access$102(TermShellAdapter x0, TermStatus x1) {
        x0.status = x1;
        return x0.status;
    }
}

