/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import java.lang.reflect.Method;
import java.util.Map;
import javax.jcr.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCR {
    public static Repository getRepository(Map<String, String> properties) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> eXoContainerContextClass = cl.loadClass("org.exoplatform.container.ExoContainerContext");
        Method getTopContainerMethod = eXoContainerContextClass.getMethod("getTopContainer", new Class[0]);
        Object topContainer = getTopContainerMethod.invoke(null, new Object[0]);
        if (topContainer != null) {
            Object container;
            String containerName = properties.get("exo.container.name");
            if (containerName != null) {
                Method getPortalContainerMethod = topContainer.getClass().getMethod("getPortalContainer", String.class);
                container = getPortalContainerMethod.invoke(topContainer, containerName);
            } else {
                container = topContainer;
            }
            if (container != null) {
                Method getComponentInstanceOfTypeMethod = container.getClass().getMethod("getComponentInstanceOfType", Class.class);
                Class<?> repositoryServiceClass = Thread.currentThread().getContextClassLoader().loadClass("org.exoplatform.services.jcr.RepositoryService");
                Object repositoryService = getComponentInstanceOfTypeMethod.invoke(container, repositoryServiceClass);
                if (repositoryService != null) {
                    Method getDefaultRepositoryMethod = repositoryService.getClass().getMethod("getDefaultRepository", new Class[0]);
                    return (Repository)getDefaultRepositoryMethod.invoke(repositoryService, new Object[0]);
                }
            }
        }
        return null;
    }
}

