/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.crsh.shell.io.ShellWriter;
import org.crsh.shell.io.ShellWriterContext;
import org.crsh.shell.ui.Element;
import org.crsh.shell.ui.UIWriterContext;

public class TreeElement
extends Element {
    private Element value;
    private List<Element> nodes = new ArrayList<Element>();

    public TreeElement() {
        this(null);
    }

    public TreeElement(Element value) {
        this.value = value;
    }

    public TreeElement addNode(Element node) {
        this.nodes.add(node);
        return this;
    }

    public int getSize() {
        return this.nodes.size();
    }

    public Element getValue() {
        return this.value;
    }

    public Element getNode(int index) {
        return this.nodes.get(index);
    }

    void print(UIWriterContext ctx, ShellWriter writer) throws IOException {
        if (ctx == null) {
            ctx = new UIWriterContext();
        }
        if (this.value != null) {
            this.value.print(ctx, writer);
            writer.append((ShellWriterContext)ctx, '\n');
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            ctx.stack.add(Boolean.TRUE);
            Element node = this.nodes.get(i);
            node.print(ctx, writer);
            if (ctx.needLF) {
                writer.append((ShellWriterContext)ctx, '\n');
            }
            ctx.stack.remove(ctx.stack.size() - 1);
        }
    }
}

