/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import groovy.lang.Closure;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.beans.IntrospectionException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.crsh.jcr.JCRUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeMetaClass
extends MetaClassImpl {
    public static void setup() {
    }

    public NodeMetaClass(MetaClassRegistry registry, Class<? extends Node> theClass) throws IntrospectionException {
        super(registry, theClass);
    }

    public Object invokeMethod(Object object, String name, Object[] args) {
        try {
            return this._invokeMethod(object, name, args);
        }
        catch (RepositoryException e) {
            throw new Error(e);
        }
    }

    private Object _invokeMethod(Object object, String name, Object[] args) throws RepositoryException {
        MetaMethod validMethod;
        Node node = (Node)object;
        if (args != null) {
            if (args.length == 0) {
                if ("iterator".equals(name)) {
                    return node.getNodes();
                }
            } else if (args.length == 1) {
                Object arg = args[0];
                if (arg instanceof String && "getProperty".equals(name)) {
                    String propertyName = (String)arg;
                    return JCRUtils.getProperty((Node)node, (String)propertyName);
                }
                if (arg instanceof Closure) {
                    Closure closure = (Closure)arg;
                    if ("eachProperty".equals(name)) {
                        PropertyIterator properties = node.getProperties();
                        while (properties.hasNext()) {
                            Property n = properties.nextProperty();
                            closure.call(new Object[]{n});
                        }
                        return null;
                    }
                } else if ("getAt".equals(name) && arg instanceof Integer) {
                    NodeIterator it = node.getNodes();
                    long size = it.getSize();
                    long index = ((Integer)arg).intValue();
                    if (index < 0L) {
                        if (index < -size) {
                            throw new ArrayIndexOutOfBoundsException((int)index);
                        }
                        index = size + index;
                    } else if (index >= size) {
                        throw new ArrayIndexOutOfBoundsException((int)index);
                    }
                    it.skip(index);
                    return it.next();
                }
            } else if (args.length == 2) {
                Object arg0 = args[0];
                Object arg1 = args[1];
                if (arg0 instanceof String && "setProperty".equals(name)) {
                    String propertyName = (String)arg0;
                    if (arg1 instanceof Boolean) {
                        JCRUtils.setProperty((Node)node, (String)propertyName, (boolean)((Boolean)arg1));
                        return null;
                    }
                }
            }
        }
        if ((validMethod = super.getMetaMethod(name, args)) != null) {
            return validMethod.invoke((Object)node, args);
        }
        throw new MissingMethodException(name, Node.class, args);
    }

    public Object getProperty(Object object, String property) {
        try {
            return this._getProperty(object, property);
        }
        catch (RepositoryException e) {
            throw new Error(e);
        }
    }

    private Object _getProperty(Object object, String propertyName) throws RepositoryException {
        Node node = (Node)object;
        MetaProperty metaProperty = super.getMetaProperty(propertyName);
        if (metaProperty != null) {
            return metaProperty.getProperty((Object)node);
        }
        try {
            Property property = node.getProperty(propertyName);
            int type = property.getType();
            switch (type) {
                case 1: 
                case 8: {
                    return property.getString();
                }
                case 5: {
                    return property.getDate();
                }
                case 4: {
                    return property.getDouble();
                }
                case 3: {
                    return property.getLong();
                }
                case 6: {
                    return property.getBoolean();
                }
                case 9: {
                    return property.getNode();
                }
                case 2: {
                    return property.getStream();
                }
            }
            throw new UnsupportedOperationException("JCR Property type " + type + " not handled yet");
        }
        catch (PathNotFoundException e) {
            try {
                return node.getNode(propertyName);
            }
            catch (PathNotFoundException e2) {
                return null;
            }
        }
    }

    public void setProperty(Object object, String property, Object newValue) {
        try {
            this._setProperty(object, property, newValue);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _setProperty(Object object, String property, Object newValue) throws RepositoryException {
        Node node = (Node)object;
        if (newValue instanceof BigDecimal) {
            BigDecimal bdValue = (BigDecimal)newValue;
            newValue = bdValue.doubleValue();
        } else if (newValue instanceof BigInteger) {
            BigInteger biValue = (BigInteger)newValue;
            newValue = biValue.longValue();
        } else if (newValue instanceof Character) {
            newValue = Character.toString(((Character)newValue).charValue());
        }
        if (newValue != null && !JCRUtils.isJCRPropertyType((Object)newValue)) throw new MissingPropertyException("Property $name does not have a correct type");
        if (newValue == null) {
            node.setProperty(property, (Value)null);
            return;
        } else if (newValue instanceof Double) {
            node.setProperty(property, ((Double)newValue).doubleValue());
            return;
        } else if (newValue instanceof String) {
            node.setProperty(property, (String)newValue);
            return;
        } else if (newValue instanceof Long) {
            node.setProperty(property, ((Long)newValue).longValue());
            return;
        } else if (newValue instanceof Integer) {
            node.setProperty(property, (long)((Integer)newValue).intValue());
            return;
        } else if (newValue instanceof Byte) {
            node.setProperty(property, (long)((Byte)newValue).byteValue());
            return;
        } else if (newValue instanceof Boolean) {
            node.setProperty(property, ((Boolean)newValue).booleanValue());
            return;
        } else if (newValue instanceof Calendar) {
            node.setProperty(property, (Calendar)newValue);
            return;
        } else if (newValue instanceof Float) {
            node.setProperty(property, (double)((Float)newValue).floatValue());
            return;
        } else {
            if (!(newValue instanceof InputStream)) throw new UnsupportedOperationException("todo with object " + newValue);
            node.setProperty(property, (InputStream)newValue);
        }
    }

    static {
        try {
            MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
            Class<?> eXoNode = Thread.currentThread().getContextClassLoader().loadClass("org.exoplatform.services.jcr.impl.core.NodeImpl");
            NodeMetaClass mc2 = new NodeMetaClass(registry, eXoNode);
            mc2.initialize();
            registry.setMetaClass(eXoNode, (MetaClass)mc2);
        }
        catch (Exception e) {
            throw new Error("Coult not integrate node meta class");
        }
    }
}

