/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.util.List;
import java.util.concurrent.Callable;
import org.crsh.display.DisplayBuilder;
import org.crsh.shell.ErrorType;
import org.crsh.shell.LineFormat;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellCommand;
import org.crsh.shell.ShellResponse;
import org.crsh.util.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Evaluable
implements Callable<ShellResponse> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Shell shell;
    private final String s;
    private final CompletionHandler<ShellResponse> handler;

    public Evaluable(Shell shell, String s, CompletionHandler<ShellResponse> handler) {
        this.shell = shell;
        this.s = s;
        this.handler = handler;
    }

    @Override
    public ShellResponse call() {
        Object response;
        block6: {
            String s2 = this.s.trim();
            this.log.debug("Invoking command " + s2);
            if (s2.length() > 0) {
                try {
                    List chunks = LineFormat.format((String)s2);
                    ShellCommand cmd = this.shell.getClosure((String)chunks.get(0));
                    if (cmd != null) {
                        String[] args = new String[chunks.size() - 1];
                        chunks.subList(1, chunks.size()).toArray(args);
                        Object o = cmd.execute(this.shell.commandContext, args);
                        response = o instanceof DisplayBuilder ? new ShellResponse.Display(((DisplayBuilder)o).getElements()) : (o != null ? new ShellResponse.Display(o.toString()) : new ShellResponse.Ok());
                        break block6;
                    }
                    response = new ShellResponse.UnkownCommand((String)chunks.get(0));
                }
                catch (Throwable t) {
                    response = new ShellResponse.Error(ErrorType.EVALUATION, t);
                }
            } else {
                response = new ShellResponse.NoCommand();
            }
        }
        this.log.debug("Making handler response callback");
        if (this.handler != null) {
            this.handler.completed(response);
        }
        return response;
    }
}

