/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.crsh.command.CommandContext;
import org.crsh.command.ScriptCommand;
import org.crsh.command.ShellCommand;
import org.crsh.display.DisplayBuilder;
import org.crsh.jcr.NodeMetaClass;
import org.crsh.shell.ErrorType;
import org.crsh.shell.Resource;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.ShellResponseContext;
import org.crsh.shell.impl.CommandContextImpl;
import org.crsh.shell.impl.LineFormat;
import org.crsh.util.TimestampedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRaSH
implements Shell {
    private static final Logger log;
    private final GroovyShell groovyShell;
    private final StringBuffer out;
    private final ShellContext context;
    private final Map<String, TimestampedObject<Class<ShellCommand>>> commands;
    final Map<String, Object> attributes;

    ShellCommand getClosure(String name) {
        TimestampedObject closure = (TimestampedObject)this.commands.get(name);
        String id = "/groovy/commands/" + name + ".groovy";
        Resource script = this.context.loadResource(id);
        if (script != null) {
            if (closure != null && script.getTimestamp() != closure.getTimestamp()) {
                closure = null;
            }
            if (closure == null) {
                Class clazz = this.groovyShell.getClassLoader().parseClass(script.getContent(), id);
                if (ShellCommand.class.isAssignableFrom(clazz)) {
                    Class commandClazz = clazz;
                    closure = this.biltooo(script.getTimestamp(), commandClazz);
                    this.commands.put(name, closure);
                } else {
                    log.error("Parsed script does not implements " + ShellCommand.class.getName());
                }
            }
        }
        try {
            return (ShellCommand)((Class)closure.getObject()).newInstance();
        }
        catch (InstantiationException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    private <T extends ShellCommand> TimestampedObject<Class<T>> biltooo(long timestamp, Class<T> aaa) {
        return new TimestampedObject(timestamp, aaa);
    }

    public GroovyShell getGroovyShell() {
        return this.groovyShell;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public CRaSH(ShellContext context) {
        HashMap attributes = new HashMap();
        CompilerConfiguration config = new CompilerConfiguration();
        config.setRecompileGroovySource(true);
        config.setScriptBaseClass(ScriptCommand.class.getName());
        GroovyShell groovyShell = new GroovyShell(context.getLoader(), new Binding(attributes), config);
        String script = context.loadResource("/groovy/login.groovy").getContent();
        groovyShell.evaluate(script, "/groovy/login.groovy");
        this.attributes = attributes;
        this.out = new StringBuffer();
        this.groovyShell = groovyShell;
        this.commands = new ConcurrentHashMap();
        this.context = context;
    }

    public void close() {
        String script = this.context.loadResource("/groovy/logout.groovy").getContent();
        this.groovyShell.evaluate(script, "/groovy/logout.groovy");
    }

    public ShellResponse evaluate(String request) {
        return this.evaluate(request, null);
    }

    public String getPrompt() {
        return (String)this.groovyShell.evaluate("prompt();");
    }

    public ShellResponse evaluate(String request, ShellResponseContext responseContext) {
        Object response;
        block5: {
            String s2 = request.trim();
            log.debug("Invoking command " + s2);
            if (s2.length() > 0) {
                try {
                    List chunks = LineFormat.format((String)s2);
                    ShellCommand cmd = this.getClosure((String)chunks.get(0));
                    CommandContextImpl ctx = new CommandContextImpl(responseContext, this.attributes);
                    if (cmd != null) {
                        String[] args = new String[chunks.size() - 1];
                        chunks.subList(1, chunks.size()).toArray(args);
                        Object o = cmd.execute((CommandContext)ctx, args);
                        response = o instanceof DisplayBuilder ? new ShellResponse.Display(((DisplayBuilder)o).getElements()) : (o != null ? new ShellResponse.Display(o.toString()) : new ShellResponse.Ok());
                        break block5;
                    }
                    response = new ShellResponse.UnkownCommand((String)chunks.get(0));
                }
                catch (Throwable t) {
                    response = new ShellResponse.Error(ErrorType.EVALUATION, t);
                }
            } else {
                response = new ShellResponse.NoCommand();
            }
        }
        return response;
    }

    static {
        NodeMetaClass.setup();
        log = LoggerFactory.getLogger(CRaSH.class);
    }
}

