/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.crsh.shell.io.ShellWriter;
import org.crsh.shell.ui.Element;
import org.crsh.shell.ui.Pad;
import org.crsh.shell.ui.TableElement;
import org.crsh.shell.ui.UIWriterContext;
import org.crsh.text.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowElement
extends Element {
    private List<Element> cols = new ArrayList<Element>();

    @Override
    public void print(UIWriterContext ctx, ShellWriter writer) throws IOException {
        this.doPrint(ctx, writer);
    }

    @Override
    void doPrint(UIWriterContext ctx, ShellWriter writer) throws IOException {
        int i = 0;
        TableElement table = (TableElement)this.getParent();
        List<Integer> colsSize = table.getColsSize();
        for (Element e : this.cols) {
            ctx.pad(writer);
            if (ctx.needLF) {
                writer.append("\n");
                ctx.parentUIContext.pad(writer);
            }
            ctx.stack.clear();
            ctx.padStyle = null;
            e.print(ctx, writer);
            ctx.padStyle = Style.style(e.getDecoration(), e.getForeground(), e.getBackground());
            for (int j = 0; j < colsSize.get(i) - e.width(); ++j) {
                ctx.stack.add(Pad.SPACE);
            }
            ++i;
            ctx.needLF = false;
        }
        ctx.needLF = true;
    }

    @Override
    int width() {
        return 0;
    }

    public void addValue(Element element) {
        this.cols.add(element);
    }

    public List<Element> getValues() {
        return this.cols;
    }
}

