/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.crsh.text.Style;
import org.crsh.util.Safe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharReader
implements Iterable<Object>,
Serializable {
    private final LinkedList<Chunk> chunks = new LinkedList();
    private Style style = null;

    public CharReader() {
    }

    public CharReader(CharSequence s) {
        this();
        this.append((Object)s);
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            Iterator<Chunk> i;
            Style nextStyle;
            StringBuilder nextBuffer;
            {
                this.i = CharReader.this.chunks.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.nextStyle != null || this.nextBuffer != null) {
                    return true;
                }
                if (this.i != null) {
                    if (this.i.hasNext()) {
                        Chunk next = this.i.next();
                        this.nextStyle = next.style;
                        this.nextBuffer = next.buffer;
                        return true;
                    }
                    this.i = null;
                    if (CharReader.this.style != null) {
                        Style last;
                        Style style = last = CharReader.this.chunks.size() > 0 ? ((Chunk)((CharReader)CharReader.this).chunks.peekLast()).style : null;
                        if (CharReader.this.style.equals(last)) {
                            return false;
                        }
                        this.nextStyle = CharReader.this.style;
                        return true;
                    }
                    return false;
                }
                return false;
            }

            @Override
            public Object next() {
                if (this.hasNext()) {
                    Serializable next;
                    if (this.nextStyle != null) {
                        next = this.nextStyle;
                        this.nextStyle = null;
                    } else {
                        next = this.nextBuffer;
                        this.nextBuffer = null;
                    }
                    return next;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void writeAnsiTo(PrintWriter writer) {
        try {
            this.writeAnsiTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeAnsiTo(Appendable appendable) throws IOException {
        for (Object o : this) {
            if (o instanceof Style) {
                try {
                    ((Style)o).writeAnsiTo(appendable);
                }
                catch (IOException ignore) {}
                continue;
            }
            if (o instanceof CharSequence) {
                appendable.append((CharSequence)o);
                continue;
            }
            appendable.append(o.toString());
        }
    }

    public CharReader append(Object ... data) throws NullPointerException {
        for (Object o : data) {
            this.append(o);
        }
        return this;
    }

    public CharReader append(Object data) throws NullPointerException {
        if (data == null) {
            throw new NullPointerException("No null accepted");
        }
        if (data instanceof CharReader) {
            CharReader reader = (CharReader)data;
            for (Chunk chunk : reader.chunks) {
                if (chunk.style != null) {
                    this.append((Object)chunk.style);
                }
                this.append((Object)chunk.buffer);
            }
            this.style = reader.style;
        } else if (data instanceof Style) {
            this.style = data == Style.reset ? Style.reset : (this.style != null ? this.style.merge((Style)data) : (Style)data);
        } else {
            CharSequence s = data instanceof CharSequence ? (CharSequence)data : data.toString();
            if (s.length() > 0) {
                Chunk chunk;
                if (this.chunks.size() > 0) {
                    Chunk last = this.chunks.peekLast();
                    if (Safe.equals(last.style, this.style)) {
                        chunk = last;
                    } else {
                        chunk = new Chunk(this.style);
                        this.chunks.addLast(chunk);
                    }
                } else {
                    chunk = new Chunk(this.style);
                    this.chunks.addLast(chunk);
                }
                chunk.buffer.append(s);
            }
        }
        return this;
    }

    public boolean contains(Object o) {
        return this.toString().contains(o.toString());
    }

    public boolean isEmpty() {
        return this.chunks.isEmpty();
    }

    public void clear() {
        this.chunks.clear();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CharReader) {
            CharReader that = (CharReader)obj;
            return this.toString().equals(that.toString());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Chunk chunk : this.chunks) {
            sb.append((CharSequence)chunk.buffer);
        }
        return sb.toString();
    }

    private static class Chunk
    implements Serializable {
        final Style style;
        final StringBuilder buffer;

        private Chunk(Style style) {
            this.style = style;
            this.buffer = new StringBuilder();
        }
    }
}

