/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.command;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandCompletion;
import org.crsh.cmdline.CommandDescriptor;
import org.crsh.cmdline.CommandFactory;
import org.crsh.cmdline.Delimiter;
import org.crsh.cmdline.IntrospectionException;
import org.crsh.cmdline.MethodDescriptor;
import org.crsh.cmdline.OptionDescriptor;
import org.crsh.cmdline.annotations.Man;
import org.crsh.cmdline.annotations.Option;
import org.crsh.cmdline.annotations.Usage;
import org.crsh.cmdline.matcher.ClassMatch;
import org.crsh.cmdline.matcher.CmdCompletionException;
import org.crsh.cmdline.matcher.CmdInvocationException;
import org.crsh.cmdline.matcher.CmdSyntaxException;
import org.crsh.cmdline.matcher.CommandMatch;
import org.crsh.cmdline.matcher.Matcher;
import org.crsh.cmdline.matcher.MethodMatch;
import org.crsh.cmdline.matcher.OptionMatch;
import org.crsh.cmdline.matcher.Resolver;
import org.crsh.cmdline.spi.Completer;
import org.crsh.cmdline.spi.ValueCompletion;
import org.crsh.command.CommandContext;
import org.crsh.command.CommandInvoker;
import org.crsh.command.DescriptionFormat;
import org.crsh.command.GroovyCommand;
import org.crsh.command.InvocationContext;
import org.crsh.command.PipeCommand;
import org.crsh.command.ScriptException;
import org.crsh.command.ShellCommand;
import org.crsh.command.SyntaxException;
import org.crsh.util.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CRaSHCommand
extends GroovyCommand
implements ShellCommand {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean unquoteArguments = true;
    private final ClassDescriptor<?> descriptor = CommandFactory.create(this.getClass());
    protected String unmatched = null;
    @Option(names={"h", "help"})
    @Usage(value="command usage")
    @Man(value="Provides command usage")
    private boolean help = false;

    protected CRaSHCommand() throws IntrospectionException {
    }

    public ClassDescriptor<?> getDescriptor() {
        return this.descriptor;
    }

    public final boolean getUnquoteArguments() {
        return this.unquoteArguments;
    }

    public final void setUnquoteArguments(boolean unquoteArguments) {
        this.unquoteArguments = unquoteArguments;
    }

    protected final String readLine(String msg) {
        return this.readLine(msg, true);
    }

    protected final String readLine(String msg, boolean echo) {
        if (this.context instanceof InvocationContext) {
            return ((InvocationContext)this.context).readLine(msg, echo);
        }
        throw new IllegalStateException("No current context of interaction with the term");
    }

    public final String getUnmatched() {
        return this.unmatched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CommandCompletion complete(CommandContext context, String line) {
        Matcher<?> analyzer = this.descriptor.matcher("main");
        Completer completer = this instanceof Completer ? (Completer)((Object)this) : null;
        try {
            this.context = context;
            CommandCompletion commandCompletion = analyzer.complete(completer, line);
            return commandCompletion;
        }
        catch (CmdCompletionException e) {
            this.log.error("Error during completion of line " + line, e);
            CommandCompletion commandCompletion = new CommandCompletion(Delimiter.EMPTY, ValueCompletion.create());
            return commandCompletion;
        }
        finally {
            this.context = null;
        }
    }

    @Override
    public final String describe(String line, DescriptionFormat mode) {
        Matcher<?> analyzer = this.descriptor.matcher("main");
        CommandMatch<?, ?, ?> match = analyzer.match(line);
        try {
            switch (mode) {
                case DESCRIBE: {
                    return ((CommandDescriptor)match.getDescriptor()).getUsage();
                }
                case MAN: {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    match.printMan(pw);
                    return sw.toString();
                }
                case USAGE: {
                    StringWriter sw2 = new StringWriter();
                    PrintWriter pw2 = new PrintWriter(sw2);
                    match.printUsage(pw2);
                    return sw2.toString();
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return null;
    }

    static ScriptException toScript(Throwable cause) {
        if (cause instanceof ScriptException) {
            return (ScriptException)cause;
        }
        if (cause instanceof groovy.util.ScriptException) {
            String msg = cause.getMessage();
            ScriptException translated = msg != null ? new ScriptException(msg) : new ScriptException();
            translated.setStackTrace(cause.getStackTrace());
            return translated;
        }
        return new ScriptException(cause);
    }

    @Override
    public CommandInvoker<?, ?> resolveInvoker(String name, Map<String, ?> options, List<?> args) {
        if (options.containsKey("h") || options.containsKey("help")) {
            throw new UnsupportedOperationException("Implement me");
        }
        Matcher<?> matcher = this.descriptor.matcher("main");
        CommandMatch<?, ?, ?> match = matcher.match(name, options, args);
        return this.resolveInvoker(match);
    }

    @Override
    public CommandInvoker<?, ?> resolveInvoker(String line) {
        Matcher<?> analyzer = this.descriptor.matcher("main");
        CommandMatch<?, ?, ?> match = analyzer.match(line);
        return this.resolveInvoker(match);
    }

    public final CommandInvoker<?, ?> resolveInvoker(final CommandMatch<CRaSHCommand, ?, ?> match) {
        if (match instanceof MethodMatch) {
            final MethodMatch methodMatch = (MethodMatch)match;
            boolean help = false;
            for (OptionMatch optionMatch : methodMatch.getOwner().getOptionMatches()) {
                OptionDescriptor optionDesc;
                Object parameterDesc = optionMatch.getParameter();
                if (!(parameterDesc instanceof OptionDescriptor) || !(optionDesc = (OptionDescriptor)parameterDesc).getNames().contains("h")) continue;
                help = true;
            }
            final boolean doHelp = help;
            return new CommandInvoker(){
                Class consumedType = Void.class;
                Class producedType = Object.class;
                {
                    Method m = ((MethodDescriptor)methodMatch.getDescriptor()).getMethod();
                    Class<?>[] parameterTypes = m.getParameterTypes();
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        Class<?> parameterType = parameterTypes[i];
                        if (!InvocationContext.class.isAssignableFrom(parameterType)) continue;
                        Type contextGenericParameterType = m.getGenericParameterTypes()[i];
                        this.producedType = TypeResolver.resolveToClass(contextGenericParameterType, InvocationContext.class, 0);
                        break;
                    }
                    if (PipeCommand.class.isAssignableFrom(m.getReturnType())) {
                        Type ret = m.getGenericReturnType();
                        this.consumedType = TypeResolver.resolveToClass(ret, PipeCommand.class, 0);
                    }
                }

                public PipeCommand invoke(final InvocationContext context) throws ScriptException {
                    if (doHelp) {
                        try {
                            match.printUsage(context.getWriter());
                            return new PipeCommand(){

                                public void provide(Object element) throws IOException {
                                }
                            };
                        }
                        catch (IOException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                    CRaSHCommand.this.pushContext(context);
                    CRaSHCommand.this.unmatched = methodMatch.getRest();
                    final Resolver resolver = new Resolver(){

                        @Override
                        public <T> T resolve(Class<T> type) {
                            if (type.equals(InvocationContext.class)) {
                                return type.cast(context);
                            }
                            return null;
                        }
                    };
                    if (this.consumedType == Void.class) {
                        return new PipeCommand(){

                            public void open() throws ScriptException {
                                Object o;
                                try {
                                    o = methodMatch.invoke(resolver, CRaSHCommand.this);
                                }
                                catch (CmdSyntaxException e) {
                                    throw new SyntaxException(e.getMessage());
                                }
                                catch (CmdInvocationException e) {
                                    throw CRaSHCommand.toScript(e.getCause());
                                }
                                finally {
                                    CRaSHCommand.this.context = null;
                                    CRaSHCommand.this.unmatched = null;
                                }
                                if (o != null) {
                                    context.getWriter().print(o);
                                }
                            }

                            public void provide(Object element) throws ScriptException, IOException {
                            }

                            public void flush() throws IOException {
                                context.flush();
                            }

                            public void close() throws ScriptException {
                                CRaSHCommand.this.popContext();
                            }
                        };
                    }
                    try {
                        return (PipeCommand)methodMatch.invoke(resolver, CRaSHCommand.this);
                    }
                    catch (CmdSyntaxException e) {
                        throw new SyntaxException(e.getMessage());
                    }
                    catch (CmdInvocationException e) {
                        throw CRaSHCommand.toScript(e.getCause());
                    }
                }

                public Class getProducedType() {
                    return this.producedType;
                }

                public Class getConsumedType() {
                    return this.consumedType;
                }
            };
        }
        if (match instanceof ClassMatch) {
            final ClassMatch classMatch = (ClassMatch)match;
            boolean help = false;
            for (OptionMatch optionMatch : classMatch.getOptionMatches()) {
                OptionDescriptor optionDesc;
                Object parameterDesc = optionMatch.getParameter();
                if (!(parameterDesc instanceof OptionDescriptor) || !(optionDesc = (OptionDescriptor)parameterDesc).getNames().contains("h")) continue;
                help = true;
            }
            final boolean doHelp = help;
            return new CommandInvoker<Void, Object>(){

                @Override
                public PipeCommand<Void> invoke(final InvocationContext<Object> context) throws ScriptException {
                    try {
                        if (doHelp) {
                            match.printUsage(context.getWriter());
                        } else {
                            classMatch.printUsage(context.getWriter());
                        }
                        return new PipeCommand<Void>(){

                            @Override
                            public void provide(Void element) throws IOException {
                            }

                            @Override
                            public void flush() throws IOException {
                                context.flush();
                            }
                        };
                    }
                    catch (IOException e) {
                        throw new AssertionError((Object)e);
                    }
                }

                @Override
                public Class<Object> getProducedType() {
                    return Object.class;
                }

                @Override
                public Class<Void> getConsumedType() {
                    return Void.class;
                }
            };
        }
        return null;
    }
}

