/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import java.util.ArrayList;
import java.util.List;
import org.crsh.text.Renderer;
import org.crsh.text.Style;
import org.crsh.text.ui.Border;
import org.crsh.text.ui.ColumnLayout;
import org.crsh.text.ui.Element;
import org.crsh.text.ui.RowElement;
import org.crsh.text.ui.TableRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableElement
extends Element {
    ArrayList<RowElement> rows = new ArrayList();
    protected Border border;
    protected ColumnLayout layout;
    protected Integer height;

    public TableElement() {
        this.layout = ColumnLayout.rightToLeft();
    }

    public TableElement(int ... weights) {
        this.layout = ColumnLayout.weighted(weights);
    }

    public TableElement add(RowElement row) {
        if (row.parent != null) {
            throw new IllegalArgumentException("Row has already a parent");
        }
        this.rows.add(row);
        row.parent = this;
        return this;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) throws IllegalArgumentException {
        if (height != null && height < 0) {
            throw new IllegalArgumentException("No negative table height accepted");
        }
        this.height = height;
    }

    public ColumnLayout getLayout() {
        return this.layout;
    }

    public Border getBorder() {
        return this.border;
    }

    @Override
    public Renderer renderer() {
        return new TableRenderer(this);
    }

    public TableElement layout(ColumnLayout layout) {
        this.layout = layout;
        return this;
    }

    public List<RowElement> getRows() {
        return this.rows;
    }

    public TableElement border(Border border) {
        this.setBorder(border);
        return this;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    @Override
    public TableElement style(Style.Composite style) {
        return (TableElement)super.style(style);
    }
}

