/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.crsh.text.LineReader;
import org.crsh.text.RenderAppendable;
import org.crsh.text.Renderer;
import org.crsh.text.Style;
import org.crsh.text.ui.Border;
import org.crsh.text.ui.ColumnLayout;
import org.crsh.text.ui.RowElement;
import org.crsh.text.ui.RowRenderer;
import org.crsh.text.ui.TableElement;

class TableRenderer
extends Renderer {
    private final List<RowRenderer> rows;
    private final ColumnLayout layout;
    private final Border border;
    private final Style.Composite style;
    private final Integer height;

    TableRenderer(TableElement table) {
        ArrayList<RowRenderer> rows = new ArrayList<RowRenderer>(table.getRows().size());
        for (RowElement row : table.getRows()) {
            rows.add(row.renderer());
        }
        this.rows = rows;
        this.layout = table.getLayout();
        this.border = table.getBorder();
        this.style = table.getStyle();
        this.height = table.getHeight();
    }

    private int getMaxColSize() {
        int n = 0;
        for (RowRenderer row : this.rows) {
            n = Math.max(n, row.getSize());
        }
        return n;
    }

    public int getMinWidth() {
        int width = 0;
        for (RowRenderer row : this.rows) {
            width = Math.max(width, row.getMinWidth());
        }
        return width;
    }

    public int getActualWidth() {
        int width = 0;
        for (RowRenderer row : this.rows) {
            width = Math.max(width, row.getActualWidth());
        }
        return width;
    }

    public LineReader renderer(final int width) {
        int borderWidth;
        int len = this.getMaxColSize();
        int[] eltWidths = new int[len];
        int[] eltMinWidths = new int[len];
        for (RowRenderer row : this.rows) {
            for (int i = 0; i < row.getCols().size(); ++i) {
                Renderer renderable = row.getCols().get(i);
                eltWidths[i] = Math.max(eltWidths[i], renderable.getActualWidth());
                eltMinWidths[i] = Math.max(eltMinWidths[i], renderable.getMinWidth());
            }
        }
        int[] widths = this.layout.compute(this.border, width, eltWidths, eltMinWidths);
        if (widths == null) {
            return new LineReader(){

                public int getWidth() {
                    return width;
                }

                public boolean hasLine() {
                    return false;
                }

                public void renderLine(RenderAppendable to) throws IllegalStateException {
                    throw new IllegalStateException();
                }
            };
        }
        final LinkedList<Object> renderers = new LinkedList<Object>();
        boolean prev = false;
        for (int i = 0; i < this.rows.size(); ++i) {
            RowRenderer row = this.rows.get(i);
            if (this.border != null && (row.isHeader() || i == 0) && !prev) {
                renderers.add((Object)this.border);
            }
            int[] bilto = this.layout.compute(this.border, width, Arrays.copyOf(eltWidths, row.getCols().size()), Arrays.copyOf(eltMinWidths, row.getCols().size()));
            renderers.add(row.renderer(bilto, width, this.border));
            if (this.border != null && (row.isHeader() || i == this.rows.size() - 1)) {
                renderers.add((Object)this.border);
                prev = true;
                continue;
            }
            prev = false;
        }
        if (this.border != null) {
            int foo = 1;
            for (int i = 0; i < widths.length; ++i) {
                if (widths[i] < eltMinWidths[i]) continue;
                foo += widths[i] + 1;
            }
            borderWidth = foo;
        } else {
            borderWidth = 0;
        }
        return new LineReader(){
            int height = 0;

            public boolean hasLine() {
                if (TableRenderer.this.height != null && this.height >= TableRenderer.this.height) {
                    return false;
                }
                while (renderers.size() > 0) {
                    Object first = renderers.peekFirst();
                    if (first instanceof LineReader) {
                        if (((LineReader)first).hasLine()) {
                            return true;
                        }
                        renderers.removeFirst();
                        continue;
                    }
                    return true;
                }
                return false;
            }

            public void renderLine(RenderAppendable to) {
                if (!this.hasLine()) {
                    throw new IllegalStateException();
                }
                while (renderers.size() > 0) {
                    int i;
                    Object first = renderers.peek();
                    if (first instanceof LineReader) {
                        if (((LineReader)first).hasLine()) {
                            if (TableRenderer.this.style != null) {
                                to.enterStyle(TableRenderer.this.style);
                                ((LineReader)first).renderLine(to);
                                to.leaveStyle();
                                break;
                            }
                            ((LineReader)first).renderLine(to);
                            break;
                        }
                        renderers.removeFirst();
                        continue;
                    }
                    Border border = (Border)((Object)first);
                    renderers.removeFirst();
                    to.styleOff();
                    to.append(border.corner);
                    for (i = 0; i < borderWidth - 2; ++i) {
                        to.append(border.horizontal);
                    }
                    to.append(border.corner);
                    for (i = borderWidth; i < width; ++i) {
                        to.append(' ');
                    }
                    to.styleOn();
                    break;
                }
                ++this.height;
            }
        };
    }
}

