/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.io.IOException;
import java.io.InputStream;

public class SubInputStream
extends InputStream {
    private final InputStream in;
    private final long length;
    private long count;

    public SubInputStream(InputStream in, long length) {
        if (in == null) {
            throw new NullPointerException("Stream cannot be null");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Length cannot be negative");
        }
        this.in = in;
        this.length = length;
        this.count = 0L;
    }

    public int read() throws IOException {
        if (this.count < this.length) {
            int value = this.in.read();
            ++this.count;
            return value;
        }
        return -1;
    }
}

