/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.type;

import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import org.crsh.cli.completers.EmptyCompleter;
import org.crsh.cli.completers.EnumCompleter;
import org.crsh.cli.spi.Completer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueType<V> {
    public static final ValueType<String> STRING = new ValueType<String>(String.class){

        @Override
        public <S extends String> S parse(Class<S> type, String s) throws Exception {
            return (S)((String)type.cast(s));
        }
    };
    public static final ValueType<Integer> INTEGER = new ValueType<Integer>(Integer.class){

        @Override
        public <S extends Integer> S parse(Class<S> type, String s) throws Exception {
            return (S)((Integer)type.cast(Integer.parseInt(s)));
        }
    };
    public static final ValueType<Boolean> BOOLEAN = new ValueType<Boolean>(Boolean.class){

        @Override
        public <S extends Boolean> S parse(Class<S> type, String s) throws Exception {
            return (S)((Boolean)type.cast(Boolean.parseBoolean(s)));
        }
    };
    public static final ValueType<Enum> ENUM = new ValueType<Enum>(Enum.class, EnumCompleter.class){

        @Override
        public <S extends Enum> S parse(Class<S> type, String s) {
            S s1 = Enum.valueOf(type, s);
            return s1;
        }
    };
    public static final ValueType<Properties> PROPERTIES = new ValueType<Properties>(Properties.class){

        @Override
        public <S extends Properties> S parse(Class<S> type, String s) throws Exception {
            Properties props = new Properties();
            StringTokenizer tokenizer = new StringTokenizer(s, ";", false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!token.contains("=")) continue;
                String key = token.substring(0, token.indexOf(61));
                String value = token.substring(token.indexOf(61) + 1, token.length());
                props.put(key, value);
            }
            return (S)((Properties)type.cast(props));
        }
    };
    public static final ValueType<ObjectName> OBJECT_NAME = new ValueType<ObjectName>(ObjectName.class){

        @Override
        public <S extends ObjectName> S parse(Class<S> type, String s) throws Exception {
            return (S)((ObjectName)type.cast(ObjectName.getInstance(s)));
        }
    };
    protected final Class<V> type;
    protected final Class<? extends Completer> completer;

    protected ValueType(Class<V> type, Class<? extends Completer> completer) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("No null value type accepted");
        }
        if (completer == null) {
            throw new NullPointerException("No null completer accepted");
        }
        this.completer = completer;
        this.type = type;
    }

    protected ValueType(Class<V> type) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("No null value type accepted");
        }
        this.completer = EmptyCompleter.class;
        this.type = type;
    }

    final int getDistance(Class<?> clazz) {
        if (this.type == clazz) {
            return 0;
        }
        if (this.type.isAssignableFrom(clazz)) {
            int degree = 0;
            for (Class<?> current = clazz; current != this.type; current = current.getSuperclass()) {
                ++degree;
            }
            return degree;
        }
        return -1;
    }

    public final int hashCode() {
        return this.type.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() == ValueType.class) {
            ValueType that = (ValueType)obj;
            return this.type == that.type;
        }
        return false;
    }

    public Class<? extends Completer> getCompleter() {
        return this.completer;
    }

    public final Class<V> getType() {
        return this.type;
    }

    public final V parse(String s) throws Exception {
        return this.parse(this.type, s);
    }

    public abstract <S extends V> S parse(Class<S> var1, String var2) throws Exception;
}

