/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.crsh.util.Safe;

public abstract class AbstractSocketServer
implements Closeable {
    private final int bindingPort;
    private ServerSocket socketServer;
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private int port;

    public AbstractSocketServer(int bindingPort) {
        this.bindingPort = bindingPort;
    }

    public final int getBindingPort() {
        return this.socketServer.getLocalPort();
    }

    public final int getPort() {
        return this.port;
    }

    public final int bind() throws IOException {
        ServerSocket socketServer = new ServerSocket();
        socketServer.bind(new InetSocketAddress(this.bindingPort));
        int port = socketServer.getLocalPort();
        this.socketServer = socketServer;
        this.port = port;
        return port;
    }

    public final void accept() throws IOException {
        if (this.socketServer == null) {
            throw new IllegalStateException();
        }
        this.socket = this.socketServer.accept();
        this.in = this.socket.getInputStream();
        this.out = this.socket.getOutputStream();
        this.handle(this.in, this.out);
    }

    protected abstract void handle(InputStream var1, OutputStream var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        try {
            Safe.close(this.socket);
            Safe.close(this.in);
            Safe.close(this.out);
        }
        finally {
            this.socket = null;
            this.in = null;
            this.out = null;
        }
    }
}

