/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.plugin.Property;
import org.crsh.plugin.PropertyDescriptor;

class PropertyManager {
    private static final Logger log = Logger.getLogger(PropertyManager.class.getName());
    private final Map<String, Property<?>> properties = new HashMap();

    PropertyManager() {
    }

    public <T> T getProperty(PropertyDescriptor<T> desc) throws NullPointerException {
        if (desc == null) {
            throw new NullPointerException();
        }
        return this.getProperty(desc.getName(), desc.getType());
    }

    <T> T getProperty(String propertyName, Class<T> type) throws NullPointerException {
        PropertyDescriptor descriptor;
        if (propertyName == null) {
            throw new NullPointerException("No null property name accepted");
        }
        if (type == null) {
            throw new NullPointerException("No null property type accepted");
        }
        Property<?> property = this.properties.get(propertyName);
        if (property != null && (descriptor = property.getDescriptor()).getType().isAssignableFrom(type)) {
            return type.cast(property.getValue());
        }
        return null;
    }

    <T> void setProperty(PropertyDescriptor<T> desc, T value) throws NullPointerException {
        if (desc == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            log.log(Level.FINE, "Removing property " + desc.name);
            this.properties.remove(desc.getName());
        } else {
            Property<T> property = new Property<T>(desc, value);
            log.log(Level.FINE, "Setting property " + desc.name + " to value " + property.getValue());
            this.properties.put(desc.getName(), property);
        }
    }

    <T> void setProperty(PropertyDescriptor<T> desc, String value) throws NullPointerException, IllegalArgumentException {
        if (desc == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            log.log(Level.FINE, "Removing property " + desc.name);
            this.properties.remove(desc.getName());
        } else {
            Property<T> property = desc.toProperty(value);
            log.log(Level.FINE, "Setting property " + desc.name + " to value " + property.getValue());
            this.properties.put(desc.getName(), property);
        }
    }
}

