/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.formatter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.crsh.text.Color;
import org.crsh.text.Decoration;
import org.crsh.text.Renderable;
import org.crsh.text.Renderer;
import org.crsh.text.ui.LabelElement;
import org.crsh.text.ui.RowElement;
import org.crsh.text.ui.TableElement;

public class MapRenderable
extends Renderable<Map<?, ?>> {
    @Override
    public Class<Map<?, ?>> getType() {
        Class<Map> mapClass = Map.class;
        return mapClass;
    }

    @Override
    public Renderer renderer(Iterator<Map<?, ?>> stream) {
        TableElement table = new TableElement();
        LinkedHashSet current = new LinkedHashSet();
        LinkedHashSet<String> bilto = new LinkedHashSet<String>();
        ArrayList<Renderer> renderers = new ArrayList<Renderer>();
        while (stream.hasNext()) {
            Map<?, ?> row = stream.next();
            if (row.size() <= 0) continue;
            bilto.clear();
            for (Map.Entry<?, ?> entry : row.entrySet()) {
                bilto.add(String.valueOf(entry.getKey()));
            }
            if (!current.equals(bilto)) {
                if (table.getRows().size() > 0) {
                    renderers.add(table.renderer());
                }
                table = new TableElement().rightCellPadding(1);
                RowElement header = new RowElement(true);
                header.style(Decoration.bold.fg(Color.black).bg(Color.white));
                for (String s : bilto) {
                    header.add(new LabelElement(s));
                }
                table.add(header);
                current = bilto;
            }
            RowElement r = new RowElement();
            for (String s : bilto) {
                String v = String.valueOf(row.get(s));
                r.add(new LabelElement(v));
            }
            table.add(r);
        }
        if (table.getRows().size() > 0) {
            renderers.add(table.renderer());
        }
        return Renderer.vertical(renderers);
    }
}

