/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.auth;

import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.crsh.auth.AuthenticationPlugin;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PropertyDescriptor;

public class JaasAuthenticationPlugin
extends CRaSHPlugin<AuthenticationPlugin>
implements AuthenticationPlugin {
    static final PropertyDescriptor<String> JAAS_DOMAIN = PropertyDescriptor.create("auth.jaas.domain", (String)null, "The JAAS domain name used for authentication");

    @Override
    public String getName() {
        return "jaas";
    }

    @Override
    protected Iterable<PropertyDescriptor<?>> createConfigurationCapabilities() {
        return Collections.singletonList(JAAS_DOMAIN);
    }

    @Override
    public boolean authenticate(final String username, final String password) throws Exception {
        String domain = this.getContext().getProperty(JAAS_DOMAIN);
        if (domain != null) {
            this.log.log(Level.FINE, "Will use the JAAS domain '" + domain + "' for authenticating user " + username);
            LoginContext loginContext = new LoginContext(domain, new Subject(), new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback c : callbacks) {
                        if (c instanceof NameCallback) {
                            ((NameCallback)c).setName(username);
                            continue;
                        }
                        if (c instanceof PasswordCallback) {
                            ((PasswordCallback)c).setPassword(password.toCharArray());
                            continue;
                        }
                        throw new UnsupportedCallbackException(c);
                    }
                }
            });
            try {
                loginContext.login();
                loginContext.logout();
                this.log.log(Level.FINE, "Authenticated user " + username + " against the JAAS domain '" + domain + "'");
                return true;
            }
            catch (Exception e) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.SEVERE, "Exception when authenticating user " + username + " to JAAS domain '" + domain + "'", e);
                }
                return false;
            }
        }
        this.log.log(Level.WARNING, "The JAAS domain property '" + JaasAuthenticationPlugin.JAAS_DOMAIN.name + "' was not found");
        return false;
    }

    @Override
    public AuthenticationPlugin getImplementation() {
        return this;
    }
}

