/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.console;

import java.io.IOException;
import org.crsh.term.spi.TermIO;

class TermIOWriter {
    private boolean previousCR;
    private final TermIO io;

    protected TermIOWriter(TermIO io) {
        this.io = io;
    }

    void write(CharSequence s) throws IOException {
        int len = s.length();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                this.writeNoFlush(c);
            }
        }
    }

    void write(char c) throws IOException {
        this.writeNoFlush(c);
    }

    private void writeNoFlush(char c) throws IOException {
        if (this.previousCR && c == '\n') {
            this.previousCR = false;
        } else if (c == '\r' || c == '\n') {
            this.previousCR = c == '\r';
            this.io.writeCRLF();
        } else {
            this.io.write(c);
        }
    }
}

