/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.util.concurrent.Callable;

public abstract class Statement {
    private Statement next;

    protected abstract void run() throws Throwable;

    public Statement with(final Runnable runnable) {
        return this.with(new Statement(){

            @Override
            protected void run() throws Throwable {
                runnable.run();
            }
        });
    }

    public Statement with(final Callable<?> callable) {
        return this.with(new Statement(){

            @Override
            protected void run() throws Throwable {
                callable.call();
            }
        });
    }

    public Statement with(Statement callback) {
        if (this.next != null) {
            this.next.with(callback);
        } else {
            this.next = callback;
        }
        return this;
    }

    public void all() {
        try {
            this.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.next != null) {
            this.next.all();
        }
    }
}

